/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.BaseObject;
import io.odilon.model.BucketMetadata;
import io.odilon.model.BucketStatus;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ObjectStatus;
import io.odilon.model.ServiceStatus;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.util.Check;
import io.odilon.util.OdilonFileUtils;
import io.odilon.virtualFileSystem.DriveInfo;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.DriveBucket;
import io.odilon.virtualFileSystem.model.DriveStatus;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import jakarta.annotation.PostConstruct;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Component
@Scope(value="prototype")
public class OdilonDrive
extends BaseObject
implements Drive {
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private static Logger logger = Logger.getLogger((String)OdilonDrive.class.getName());
    @JsonIgnore
    private ServiceStatus status = ServiceStatus.STOPPED;
    @JsonIgnore
    private ReadWriteLock drive_lock = new ReentrantReadWriteLock();
    @JsonIgnore
    private Map<Long, DriveBucket> driveBuckets = new ConcurrentHashMap();
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="rootDir")
    private String rootDir;
    @JsonProperty(value="configOrder")
    private int configOrder;
    @JsonProperty(value="driveInfo")
    DriveInfo driveInfo;
    @JsonProperty(value="raidDrives")
    private int raidDrives;
    @JsonProperty(value="raidSetup")
    private String raidSetup;

    @Autowired
    protected OdilonDrive(String string) {
        this.name = string;
        this.rootDir = string;
    }

    protected OdilonDrive(String string, String string2, int n, String string3, int n2) {
        this.name = string;
        this.rootDir = string2;
        this.configOrder = n;
        this.raidDrives = n2;
        this.raidSetup = string3;
        this.onInitialize();
    }

    @JsonIgnore
    public BucketMetadata getBucketMetadata(ServerBucket serverBucket) throws IOException {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.getBucketMetadataById(serverBucket.getId());
    }

    @JsonIgnore
    public BucketMetadata getBucketMetadataById(Long l) {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        try {
            return (BucketMetadata)this.getObjectMapper().readValue(Paths.get(this.getBucketsDirPath() + File.separator + l.toString() + File.separator + l.toString() + ".json", new String[0]).toFile(), BucketMetadata.class);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "b:" + l.toString() + ", d:" + this.getName());
        }
    }

    @JsonIgnore
    public File getObjectMetadataFile(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null " + this.objectInfo(serverBucket)));
        return this.getObjectMetadataFileById(serverBucket.getId(), string);
    }

    @JsonIgnore
    public String getBucketMetadataDirPath(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.getBucketMetadataDirPathById(serverBucket.getId());
    }

    @JsonIgnore
    public String getObjectMetadataDirPath(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null " + this.objectInfo(serverBucket)));
        return this.getObjectMetadataDirPathById(serverBucket.getId(), string);
    }

    @JsonIgnore
    public DriveInfo getDriveInfo() {
        return this.driveInfo;
    }

    public synchronized void setDriveInfo(DriveInfo driveInfo) {
        this.driveInfo = driveInfo;
        this.saveDriveMetadata(driveInfo);
    }

    @JsonIgnore
    public String getBucketWorkDirPath(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.getBucketWorkDirPathById(serverBucket.getId());
    }

    @JsonIgnore
    public String getBucketCacheDirPath(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.getBucketCacheDirPathById(serverBucket.getId());
    }

    private String getBucketCacheDirPathById(Long l) {
        return this.getCacheDirPath() + File.separator + l.toString();
    }

    @JsonIgnore
    public String getBucketObjectDataDirPath(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.getRootDirPath() + File.separator + serverBucket.getId().toString();
    }

    public void putObjectMetadataVersionFile(ServerBucket serverBucket, String string, int n, File file) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            this.putObjectMetadataVersionStream(serverBucket, string, n, (InputStream)bufferedInputStream);
        }
    }

    public void putObjectMetadataFile(ServerBucket serverBucket, String string, File file) throws IOException {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            this.putObjectMetadataStream(serverBucket, string, (InputStream)bufferedInputStream);
        }
    }

    public File createBucket(BucketMetadata bucketMetadata) throws IOException {
        Check.requireNonNullArgument((Object)bucketMetadata, (String)"meta is null");
        Check.requireNonNullStringArgument((String)bucketMetadata.bucketName, (String)"bucketName is null");
        Check.requireNonNullArgument((Object)bucketMetadata.id, (String)"Id is null");
        File file = new File(this.getBucketsDirPath() + File.separator + bucketMetadata.id.toString());
        File file2 = new File(this.getRootDirPath() + File.separator + bucketMetadata.id.toString());
        File file3 = new File(this.getCacheDirPath() + File.separator + bucketMetadata.id.toString());
        File file4 = new File(this.getRootDirPath() + File.separator + bucketMetadata.id.toString() + File.separator + "version");
        File file5 = new File(this.getWorkDirPath() + File.separator + bucketMetadata.id.toString());
        try {
            this.drive_lock.writeLock().lock();
            if (file.exists() && file.isDirectory()) {
                throw new IllegalArgumentException("Bucket already exist -> b: " + bucketMetadata.id.toString());
            }
            FileUtils.forceMkdir((File)file);
            if (!file2.exists() || !file2.isDirectory()) {
                FileUtils.forceMkdir((File)file2);
            }
            if (!file4.exists() || !file4.isDirectory()) {
                FileUtils.forceMkdir((File)file4);
            }
            if (!file5.exists() || !file5.isDirectory()) {
                FileUtils.forceMkdir((File)file5);
            }
            if (!file3.exists() || !file3.isDirectory()) {
                FileUtils.forceMkdir((File)file3);
            }
            this.saveBucketMetadata(bucketMetadata);
            File file6 = file2;
            return file6;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "b:" + bucketMetadata.id.toString() + ", d:" + this.getName());
        }
        finally {
            this.drive_lock.writeLock().unlock();
        }
    }

    public void deleteBucket(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        if (this.isEmpty(serverBucket)) {
            this.deleteBucketInternal(serverBucket);
        }
    }

    public void forceDeleteBucketById(Long l) {
        Check.requireNonNullArgument((Object)l, (String)"bucketId");
        this.deleteBucketInternal(l);
    }

    public boolean existsBucketById(Long l) {
        return new File(this.getBucketMetadataDirPathById(l)).exists();
    }

    public boolean existsObjectMetadata(ObjectMetadata objectMetadata) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        File file = new File(this.getObjectMetadataDirPathById(objectMetadata.getBucketId(), objectMetadata.getObjectName()));
        if (!file.exists()) {
            return false;
        }
        return this.getObjectMetadataById((Long)objectMetadata.getBucketId(), (String)objectMetadata.getObjectName()).status != ObjectStatus.DELETED;
    }

    public boolean existsObjectMetadata(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null " + this.objectInfo(serverBucket)));
        ObjectPath objectPath = new ObjectPath((Drive)this, serverBucket, string);
        File file = objectPath.metadataDirPath().toFile();
        if (!file.exists()) {
            return false;
        }
        return this.getObjectMetadata((ServerBucket)serverBucket, (String)string).status != ObjectStatus.DELETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsDeletedBucket(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)this.driveBuckets.containsKey(serverBucket.getId()), (String)"bucket does not exist");
        try {
            this.drive_lock.writeLock().lock();
            DriveBucket driveBucket = (DriveBucket)this.driveBuckets.get(serverBucket.getId());
            BucketMetadata bucketMetadata = driveBucket.getBucketMetadata();
            bucketMetadata.status = BucketStatus.DELETED;
            bucketMetadata.lastModified = OffsetDateTime.now();
            this.saveBucketMetadata(bucketMetadata);
        }
        finally {
            this.drive_lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsEnabledBucket(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)this.driveBuckets.containsKey(serverBucket.getId()), (String)"bucket does not exist");
        try {
            this.drive_lock.writeLock().lock();
            DriveBucket driveBucket = (DriveBucket)this.driveBuckets.get(serverBucket.getId());
            BucketMetadata bucketMetadata = driveBucket.getBucketMetadata();
            bucketMetadata.status = BucketStatus.ENABLED;
            bucketMetadata.lastModified = OffsetDateTime.now();
            this.saveBucketMetadata(bucketMetadata);
        }
        finally {
            this.drive_lock.writeLock().unlock();
        }
    }

    public void markAsDeletedObject(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null " + this.objectInfo(serverBucket)));
        ObjectMetadata objectMetadata = this.getObjectMetadata(serverBucket, string);
        objectMetadata.status = ObjectStatus.DELETED;
        this.saveObjectMetadata(objectMetadata, true);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setRootDir(String string) {
        this.rootDir = string;
    }

    @JsonIgnore
    public List<DriveBucket> getBuckets() {
        try {
            this.drive_lock.readLock().lock();
            ArrayList<DriveBucket> arrayList = new ArrayList<DriveBucket>();
            for (Map.Entry entry : this.driveBuckets.entrySet()) {
                arrayList.add((DriveBucket)entry.getValue());
            }
            arrayList.sort((Comparator<DriveBucket>)new /* Unavailable Anonymous Inner Class!! */);
            ArrayList<DriveBucket> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "getBuckets");
        }
        finally {
            this.drive_lock.readLock().unlock();
        }
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getRootDirPath() {
        return this.rootDir;
    }

    @JsonIgnore
    public String getSysDirPath() {
        return this.getRootDirPath() + File.separator + ".odilon.sys";
    }

    @JsonIgnore
    public String getWorkDirPath() {
        return this.getRootDirPath() + File.separator + ".odilon.sys" + File.separator + "work";
    }

    @JsonIgnore
    public String getCacheDirPath() {
        return this.getRootDirPath() + File.separator + ".odilon.sys" + File.separator + "cache";
    }

    @JsonIgnore
    public String getSchedulerDirPath() {
        return this.getRootDirPath() + File.separator + ".odilon.sys" + File.separator + "scheduler";
    }

    @JsonIgnore
    public String getJournalDirPath() {
        return this.getRootDirPath() + File.separator + ".odilon.sys" + File.separator + "journal";
    }

    @JsonIgnore
    public String getBucketsDirPath() {
        return this.getRootDirPath() + File.separator + ".odilon.sys" + File.separator + "buckets";
    }

    @JsonIgnore
    public String getTempDirPath() {
        return this.getRootDirPath() + File.separator + ".odilon.sys" + File.separator + "tmp";
    }

    public ObjectMetadata getObjectMetadata(ServerBucket serverBucket, String string) {
        try {
            return (ObjectMetadata)this.getObjectMapper().readValue(this.getObjectMetadataFileById(serverBucket.getId(), string), ObjectMetadata.class);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception);
        }
    }

    private ObjectMetadata getObjectMetadataById(Long l, String string) {
        try {
            return (ObjectMetadata)this.getObjectMapper().readValue(this.getObjectMetadataFileById(l, string), ObjectMetadata.class);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception);
        }
    }

    public ObjectMetadata getObjectMetadataVersion(ServerBucket serverBucket, String string, int n) {
        try {
            Check.requireNonNullArgument((Object)serverBucket, (String)"bucked is null");
            Check.requireNonNullStringArgument((String)string, (String)("objectName is null " + this.objectInfo(serverBucket)));
            File file = this.getObjectMetadataVersionFile(serverBucket, string, n);
            if (!file.exists()) {
                return null;
            }
            return (ObjectMetadata)this.getObjectMapper().readValue(file, ObjectMetadata.class);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
        }
    }

    public void saveObjectMetadata(ObjectMetadata objectMetadata) {
        this.saveObjectMetadata(objectMetadata, true);
    }

    public void saveObjectMetadataVersion(ObjectMetadata objectMetadata) {
        this.saveObjectMetadata(objectMetadata, false);
    }

    protected void saveObjectMetadata(ObjectMetadata objectMetadata, boolean bl) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta");
        Check.requireNonNullArgument((Object)objectMetadata.bucketId, (String)"meta.bucketId is null");
        Check.requireNonNullStringArgument((String)objectMetadata.objectName, (String)"meta.objectName is null");
        Optional optional = bl ? Optional.empty() : Optional.of(objectMetadata.getVersion());
        try {
            File file = new File(this.getObjectMetadataDirPathById(objectMetadata.getBucketId(), objectMetadata.getObjectName()));
            if (!file.exists()) {
                FileUtils.forceMkdir((File)file);
            }
            objectMetadata.setLastModified(OffsetDateTime.now());
            String string = this.getObjectMapper().writeValueAsString((Object)objectMetadata);
            ObjectPath objectPath = new ObjectPath((Drive)this, objectMetadata.getBucketId(), objectMetadata.getObjectName());
            if (bl) {
                Files.writeString(objectPath.metadataFilePath(), (CharSequence)string, new OpenOption[0]);
            } else {
                Files.writeString(Paths.get(this.getObjectMetadataVersionFilePathById(objectMetadata.getBucketId(), objectMetadata.getObjectName(), ((Integer)optional.get()).intValue()), new String[0]), (CharSequence)string, new OpenOption[0]);
            }
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "b:" + objectMetadata.getBucketId().toString() + "o: + " + objectMetadata.getObjectName() + " v: " + (optional.isPresent() ? String.valueOf(optional.get()) : "head"));
        }
    }

    public void removeScheduler(ServiceRequest serviceRequest, String string) {
        Check.requireNonNullStringArgument((String)string, (String)"queueId is null");
        try {
            String string2 = this.getSchedulerDirPath() + File.separator + string + File.separator + String.valueOf(serviceRequest.getId()) + ".json";
            File file = new File(string2);
            if (file.exists()) {
                Files.delete(Paths.get(string2, new String[0]));
            } else {
                logger.debug("Remove file not found -> d: " + this.getName() + " | f:" + (file != null ? file.getName() : "null"));
            }
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "op: " + (Optional.ofNullable(serviceRequest).isPresent() ? serviceRequest.toString() : "null"));
        }
    }

    public void saveScheduler(ServiceRequest serviceRequest, String string) {
        Check.requireNonNullStringArgument((String)string, (String)"queueId is null");
        Check.requireNonNullArgument((Object)serviceRequest, (String)"serviceRequest is null");
        try {
            String string2 = this.getObjectMapper().writeValueAsString((Object)serviceRequest);
            File file = new File(this.getSchedulerDirPath() + File.separator + string);
            if (!file.exists() || !file.isDirectory()) {
                try {
                    OdilonFileUtils.forceMkdir((File)file);
                }
                catch (IOException iOException) {
                    throw new InternalCriticalException((Exception)iOException, "Can not create dir -> d: " + this.getName() + " dir:" + file.getName());
                }
            }
            String string3 = this.getSchedulerDirPath() + File.separator + string + File.separator + String.valueOf(serviceRequest.getId()) + ".json";
            Files.writeString(Paths.get(string3, new String[0]), (CharSequence)string2, new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "op: " + (Optional.ofNullable(serviceRequest).isPresent() ? serviceRequest.toString() : "null"));
        }
    }

    public synchronized List<File> getSchedulerRequests(String string) {
        Check.requireNonNullStringArgument((String)string, (String)"queueId is null");
        try {
            ArrayList<File> arrayList = new ArrayList<File>();
            File file = new File(this.getSchedulerDirPath() + File.separator + string);
            if (!(file.exists() && file.isDirectory() && file.canRead())) {
                return arrayList;
            }
            for (File file2 : file.listFiles()) {
                if (!file2.exists() || file2.isDirectory()) continue;
                arrayList.add(file2);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "getSchedulerRequests " + string);
        }
    }

    public void saveJournal(VirtualFileSystemOperation virtualFileSystemOperation) {
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"op is null");
        try {
            String string = this.getObjectMapper().writeValueAsString((Object)virtualFileSystemOperation);
            Files.writeString(Paths.get(this.getJournalDirPath() + File.separator + virtualFileSystemOperation.getId() + ".json", new String[0]), (CharSequence)string, new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "op: " + (Optional.ofNullable(virtualFileSystemOperation).isPresent() ? virtualFileSystemOperation.toString() : "null"));
        }
    }

    public void removeJournal(String string) {
        Check.requireNonNullArgument((Object)string, (String)"id is null");
        try {
            Files.delete(Paths.get(this.getJournalDirPath() + File.separator + string + ".json", new String[0]));
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "id: " + (Optional.ofNullable(string).isPresent() ? string : "null"));
        }
    }

    public File getObjectMetadataVersionFile(ServerBucket serverBucket, String string, int n) {
        return new File(this.getObjectMetadataVersionFilePath(serverBucket, string, n));
    }

    private void putObjectMetadataVersionStream(ServerBucket serverBucket, String string, int n, InputStream inputStream) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)inputStream, (String)"stream is null");
        try {
            this.transferTo(inputStream, this.getObjectMetadataVersionFilePath(serverBucket, string, n));
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string) + ", version:" + String.valueOf(n) + ", d:" + this.getName());
        }
    }

    public void removeSysFile(String string) {
        Check.requireNonNullStringArgument((String)string, (String)"fileName is null");
        try {
            Files.delete(Paths.get(this.getRootDirPath() + File.separator + ".odilon.sys" + File.separator + string, new String[0]));
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.fileInfo(string));
        }
    }

    public void putSysFile(String string, String string2) {
        Check.requireNonNullStringArgument((String)string, (String)"fileName is null");
        Check.requireNonNullStringArgument((String)string2, (String)("content can not be null | f:" + string));
        try {
            Files.writeString(Paths.get(this.getRootDirPath() + File.separator + ".odilon.sys" + File.separator + string, new String[0]), (CharSequence)string2, new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "f:" + string + " d:" + this.getName());
        }
    }

    public File getSysFile(String string) {
        Check.requireNonNullStringArgument((String)string, (String)"fileName is null");
        return new File(this.getRootDirPath() + File.separator + ".odilon.sys" + File.separator + string);
    }

    public boolean isEmpty(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        return this.isEmpty(serverBucket.getId());
    }

    private boolean isEmpty(Long l) {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        File file = new File(this.getBucketMetadataDirPathById(l));
        Path path2 = file.toPath();
        if (Files.isDirectory(path2, new LinkOption[0])) {
            boolean bl;
            block9: {
                Stream<Path> stream = Files.list(path2);
                try {
                    boolean bl2 = bl = !stream.filter(path -> path.toFile().isDirectory()).findFirst().isPresent();
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new InternalCriticalException((Exception)iOException, "b:" + l.toString());
                    }
                }
                stream.close();
            }
            return bl;
        }
        return true;
    }

    public void setStatus(ServiceStatus serviceStatus) {
        this.status = serviceStatus;
    }

    @JsonIgnore
    public ServiceStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Drive)) {
            return false;
        }
        if (((Drive)object).getName() == null || ((Drive)object).getRootDirPath() == null) {
            return false;
        }
        if (this.name == null || this.rootDir == null) {
            return false;
        }
        return this.name.equals(((Drive)object).getName()) && this.rootDir.equals(((Drive)object).getRootDirPath());
    }

    public String ping() {
        return "ok";
    }

    protected void transferTo(InputStream inputStream, String string) throws IOException {
        byte[] byArray = new byte[8192];
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string), 8192);
            while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    @JsonIgnore
    public long getAvailableSpace() {
        File file = new File(this.getRootDirPath());
        return file.getUsableSpace();
    }

    @JsonIgnore
    public long getTotalSpace() {
        File file = new File(this.getRootDirPath());
        return file.getTotalSpace();
    }

    public void setConfigOrder(int n) {
        this.configOrder = n;
    }

    @JsonIgnore
    public int getConfigOrder() {
        return this.configOrder;
    }

    public synchronized void cleanUpCacheDir(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        try {
            int n = 0;
            File file = new File(this.getBucketCacheDirPath(serverBucket));
            if (file.exists()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    FileUtils.deleteQuietly((File)file2);
                    if (n++ > 50000) break;
                }
            }
            if (n > 0) {
                logger.debug("Removed temp files from  dir:" + this.getBucketCacheDirPath(serverBucket) + " | b:" + serverBucket.getName() + " total:" + String.valueOf(n));
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    public synchronized void cleanUpWorkDir(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        try {
            int n = 0;
            File file = new File(this.getBucketWorkDirPath(serverBucket));
            if (file.exists()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    FileUtils.deleteQuietly((File)file2);
                    if (n++ > 50000) break;
                }
            }
            if (n > 0) {
                logger.debug("Removed temp files from dir: " + this.getBucketWorkDirPath(serverBucket) + " | b:" + serverBucket.getName() + " total:" + String.valueOf(n));
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    @PostConstruct
    protected void onInitialize() {
        try {
            File file;
            File file2;
            File file3;
            File file4;
            File file5;
            this.setStatus(ServiceStatus.STARTING);
            File file6 = new File(this.getRootDirPath());
            this.drive_lock.writeLock().lock();
            if (!file6.exists() || !file6.isDirectory()) {
                this.createRootDirectory();
            }
            if (!(file5 = new File(this.getSysDirPath())).exists() || !file5.isDirectory()) {
                this.createSysDirectory();
            }
            if (!(file4 = new File(this.getBucketsDirPath())).exists() || !file4.isDirectory()) {
                this.createBucketsDirectory();
            }
            this.checkBucketDataVersionDirs();
            File file7 = new File(this.getJournalDirPath());
            if (!file7.exists() || !file7.isDirectory()) {
                this.createJournalDirectory();
            }
            if (!(file3 = new File(this.getTempDirPath())).exists() || !file3.isDirectory()) {
                this.createTempDirectory();
            }
            if (!(file2 = new File(this.getWorkDirPath())).exists() || !file2.isDirectory()) {
                this.createWorkDirectory();
            }
            if (!(file = new File(this.getCacheDirPath())).exists() || !file.isDirectory()) {
                this.createCacheDirectory();
            }
            this.checkWorkBucketDirs();
            File file8 = new File(this.getSchedulerDirPath());
            if (!file8.exists() || !file8.isDirectory()) {
                this.createSchedulerDirectory();
            }
            DriveInfo driveInfo = this.readDriveMetadata();
            if (this.readDriveMetadata() == null) {
                driveInfo = new DriveInfo(this.getName(), this.randomString(12), OffsetDateTime.now(), DriveStatus.NOTSYNC, this.getConfigOrder(), this.raidSetup, this.raidDrives);
                this.saveDriveMetadata(driveInfo);
            }
            this.driveInfo = this.readDriveMetadata();
            this.loadBuckets();
            this.setStatus(ServiceStatus.RUNNING);
        }
        catch (Exception exception) {
            this.setStatus(ServiceStatus.STOPPED);
            throw new InternalCriticalException(exception, "Drive Startup | d:" + this.getName());
        }
        finally {
            this.drive_lock.writeLock().unlock();
            startuplogger.debug("Started -> Drive: " + this.name + " | rootDir: " + this.rootDir);
        }
    }

    protected void deleteBucketInternal(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)this.isEmpty(serverBucket), (String)("bucket is not empty -> " + this.objectInfo(serverBucket)));
        this.deleteBucketInternal(serverBucket.getId());
    }

    protected void deleteBucketInternal(Long l) {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        File file = new File(this.getBucketsDirPath() + File.separator + l.toString());
        File file2 = new File(this.getRootDirPath() + File.separator + l.toString());
        File file3 = new File(this.getRootDirPath() + File.separator + l.toString() + File.separator + "version");
        File file4 = new File(this.getBucketWorkDirPathById(l));
        boolean bl = false;
        try {
            this.drive_lock.writeLock().lock();
            if (file.exists() && file.isDirectory()) {
                FileUtils.deleteQuietly((File)file);
                this.driveBuckets.remove(l);
                bl = true;
            }
            if (file2.exists() && file2.isDirectory()) {
                FileUtils.deleteQuietly((File)file2);
            }
            if (file3.exists() && file3.isDirectory()) {
                FileUtils.deleteQuietly((File)file3);
            }
            if (file4.exists() && file4.isDirectory()) {
                FileUtils.deleteQuietly((File)file4);
            }
        }
        catch (Exception exception) {
            if (bl) {
                return;
            }
            throw exception;
        }
        finally {
            this.drive_lock.writeLock().unlock();
        }
    }

    public void updateBucket(BucketMetadata bucketMetadata) throws IOException {
        Check.requireNonNullArgument((Object)bucketMetadata, (String)"meta is null");
        this.saveBucketMetadata(bucketMetadata);
    }

    protected void saveBucketMetadata(BucketMetadata bucketMetadata) {
        Check.requireNonNullArgument((Object)bucketMetadata, (String)"meta is null");
        Check.requireNonNullArgument((Object)bucketMetadata.id, (String)"meta.id is null");
        try {
            String string = this.getObjectMapper().writeValueAsString((Object)bucketMetadata);
            Files.writeString(Paths.get(this.getBucketsDirPath() + File.separator + bucketMetadata.id.toString() + File.separator + bucketMetadata.id.toString() + ".json", new String[0]), (CharSequence)string, new OpenOption[0]);
            this.driveBuckets.put(bucketMetadata.id, new DriveBucket((Drive)this, bucketMetadata));
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "b:" + bucketMetadata.bucketName + ", d:" + this.getName());
        }
    }

    protected void createDataBucketDirIfNotExists(Long l) {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        try {
            this.drive_lock.writeLock().lock();
            if (!Files.exists(Paths.get(this.getRootDirPath() + File.separator + l.toString(), new String[0]), new LinkOption[0])) {
                logger.debug("Creating Data Bucket Directory for  -> b:" + l.toString());
                OdilonFileUtils.forceMkdir((File)new File(this.getRootDirPath() + File.separator + l.toString()));
            }
            if (!Files.exists(Paths.get(this.getRootDirPath() + File.separator + l.toString() + File.separator + "version", new String[0]), new LinkOption[0])) {
                OdilonFileUtils.forceMkdir((File)new File(this.getRootDirPath() + File.separator + l.toString() + File.separator + "version"));
            }
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, "Can not create Bucket Data Directory -> d:" + this.getName() + " b:" + Optional.ofNullable(l.toString()).orElse("null"));
        }
        finally {
            this.drive_lock.writeLock().unlock();
        }
    }

    protected boolean existBucketMetadataDir(ServerBucket serverBucket) {
        return Files.exists(Paths.get(this.getBucketMetadataDirPath(serverBucket), new String[0]), new LinkOption[0]);
    }

    protected void createRootDirectory() {
        try {
            logger.debug("Creating Data Directory -> " + this.getRootDirPath());
            OdilonFileUtils.forceMkdir((File)new File(this.getRootDirPath()));
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, "Can not create root Directory -> dir:" + this.rootDir + "  | d:" + this.name);
        }
    }

    protected void createSysDirectory() {
        try {
            logger.debug("Creating Directory -> " + this.getSysDirPath());
            OdilonFileUtils.forceMkdir((File)new File(this.getSysDirPath()));
        }
        catch (IOException iOException) {
            String string = "Can not create sys Directory ->  dir:" + this.getSysDirPath() + "  d:" + this.name;
            throw new InternalCriticalException((Exception)iOException, string);
        }
    }

    private void createWorkDirectory() {
        try {
            logger.debug("Creating Directory -> " + this.getWorkDirPath());
            OdilonFileUtils.forceMkdir((File)new File(this.getWorkDirPath()));
        }
        catch (IOException iOException) {
            String string = "Can not create work Directory ->  dir:" + this.getWorkDirPath() + "  d:" + this.name;
            throw new InternalCriticalException((Exception)iOException, string);
        }
    }

    private void createCacheDirectory() {
        try {
            logger.debug("Creating Directory -> " + this.getCacheDirPath());
            OdilonFileUtils.forceMkdir((File)new File(this.getCacheDirPath()));
        }
        catch (IOException iOException) {
            String string = "Can not create cache Directory ->  dir:" + this.getCacheDirPath() + "  d:" + this.name;
            throw new InternalCriticalException((Exception)iOException, string);
        }
    }

    private void createSchedulerDirectory() {
        try {
            logger.debug("Creating Directory -> " + this.getSchedulerDirPath());
            OdilonFileUtils.forceMkdir((File)new File(this.getSchedulerDirPath()));
        }
        catch (IOException iOException) {
            String string = "Can not create scheduler Directory ->  dir:" + this.getSchedulerDirPath() + "  d:" + this.name;
            throw new InternalCriticalException((Exception)iOException, string);
        }
    }

    private void createBucketsDirectory() {
        try {
            logger.debug("Creating Directory -> " + this.getBucketsDirPath());
            OdilonFileUtils.forceMkdir((File)new File(this.getBucketsDirPath()));
        }
        catch (IOException iOException) {
            String string = "Can not create Buckets Metadata Directory ->  dir:" + this.getBucketsDirPath() + "  d:" + this.name;
            throw new InternalCriticalException((Exception)iOException, string);
        }
    }

    private void createJournalDirectory() {
        try {
            logger.debug("Creating Directory -> " + this.getJournalDirPath());
            OdilonFileUtils.forceMkdir((File)new File(this.getJournalDirPath()));
        }
        catch (IOException iOException) {
            String string = "Can not create Journal Directory ->  dir:" + this.getJournalDirPath() + "  d:" + this.name;
            throw new InternalCriticalException((Exception)iOException, string);
        }
    }

    private void createTempDirectory() {
        try {
            logger.debug("Creating Directory -> " + this.getTempDirPath());
            OdilonFileUtils.forceMkdir((File)new File(this.getTempDirPath()));
        }
        catch (IOException iOException) {
            String string = "Can not create temp Directory ->  dir:" + this.getTempDirPath() + "  d:" + this.name;
            throw new InternalCriticalException((Exception)iOException, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkWorkBucketDirs() {
        Path path2 = new File(this.getBucketsDirPath()).toPath();
        Stream<Path> stream = null;
        try {
            stream = Files.walk(path2, 1, new FileVisitOption[0]).skip(1L).filter(path -> Files.isDirectory(path, new LinkOption[0]));
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, "checkWorkBucketDirs");
        }
        try {
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                File file;
                Path path3 = (Path)iterator.next();
                Long l = Long.valueOf(path3.toFile().getName());
                File file2 = new File(this.getBucketWorkDirPathById(l));
                if (!file2.exists()) {
                    logger.debug("Creating Directory -> " + file2.getName());
                    try {
                        OdilonFileUtils.forceMkdir((File)file2);
                    }
                    catch (IOException iOException) {
                        throw new InternalCriticalException((Exception)iOException, "Can not create -> " + file2.getName());
                    }
                }
                if ((file = new File(this.getBucketCacheDirPathById(l))).exists()) continue;
                logger.debug("Creating Directory -> " + file.getName());
                try {
                    OdilonFileUtils.forceMkdir((File)file);
                }
                catch (IOException iOException) {
                    throw new InternalCriticalException((Exception)iOException, "Can not create -> " + file.getName());
                    return;
                }
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkBucketDataVersionDirs() {
        Path path2 = new File(this.getRootDirPath()).toPath();
        Stream<Path> stream = null;
        try {
            stream = Files.walk(path2, 1, new FileVisitOption[0]).skip(1L).filter(path -> Files.isDirectory(path, new LinkOption[0])).filter(path -> !path.getFileName().toString().equals(".odilon.sys"));
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, "checkBucketDataVersionDirs");
        }
        try {
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                Path path3 = (Path)iterator.next();
                String string = path3.toFile().getAbsolutePath() + File.separator + "version";
                boolean bl = new File(string).exists();
                if (bl) continue;
                logger.debug("Creating Directory -> " + string);
                try {
                    OdilonFileUtils.forceMkdir((File)new File(string));
                }
                catch (IOException iOException) {
                    throw new InternalCriticalException((Exception)iOException, "Can not create -> " + string);
                    return;
                }
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private void loadBuckets() {
        try {
            this.drive_lock.readLock().lock();
            try {
                List<Path> list = Files.walk(Paths.get(this.getBucketsDirPath(), new String[0]), 1, new FileVisitOption[0]).filter((Predicate<Path>)new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
                list.forEach(path -> {
                    try {
                        this.driveBuckets.put(Long.valueOf(path.toFile().getName()), new DriveBucket((Drive)this, this.getBucketMetadataById(Long.valueOf(path.toFile().getName()))));
                    }
                    catch (IOException iOException) {
                        throw new InternalCriticalException((Exception)iOException, "loadbuckets");
                    }
                });
            }
            catch (IOException iOException) {
                throw new InternalCriticalException((Exception)iOException, "loadbuckets");
            }
        }
        finally {
            this.drive_lock.readLock().unlock();
        }
    }

    private synchronized void saveDriveMetadata(DriveInfo driveInfo) {
        Check.requireNonNullArgument((Object)driveInfo, (String)"info is null");
        String string = null;
        try {
            string = this.getObjectMapper().writeValueAsString((Object)driveInfo);
            Files.writeString(Paths.get(this.getSysDirPath() + File.separator + "driveInfo.json", new String[0]), (CharSequence)string, new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "json:" + (Optional.ofNullable(string).isPresent() ? string : "null"));
        }
    }

    private synchronized DriveInfo readDriveMetadata() {
        File file = null;
        try {
            file = new File(this.getSysDirPath() + File.separator + "driveInfo.json");
            if (!file.exists()) {
                return null;
            }
            String string = Files.readString(file.toPath());
            DriveInfo driveInfo = (DriveInfo)this.getObjectMapper().readValue(string, DriveInfo.class);
            return driveInfo;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, "f:" + (Optional.ofNullable(file).isPresent() ? file.getName() : "null"));
        }
    }

    private String getObjectMetadataFilePathById(Long l, String string) {
        return this.getObjectMetadataDirPathById(l, string) + File.separator + string + ".json";
    }

    private String getObjectMetadataVersionFilePath(ServerBucket serverBucket, String string, int n) {
        return this.getObjectMetadataDirPath(serverBucket, string) + File.separator + string + ".v" + String.valueOf(n) + ".json";
    }

    private String getObjectMetadataVersionFilePathById(Long l, String string, int n) {
        return this.getObjectMetadataDirPathById(l, string) + File.separator + string + ".v" + String.valueOf(n) + ".json";
    }

    private void putObjectMetadataStream(ServerBucket serverBucket, String string, InputStream inputStream) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null " + this.objectInfo(serverBucket)));
        Check.requireNonNullArgument((Object)inputStream, (String)"stream is null");
        if (!this.existBucketMetadataDir(serverBucket)) {
            throw new IllegalArgumentException("Bucket Metadata Directory must exist -> d:" + this.getName() + " | b:" + this.objectInfo(serverBucket));
        }
        try {
            this.transferTo(inputStream, this.getBucketMetadataDirPath(serverBucket) + File.separator + string + File.separator + string + ".json");
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
        }
    }

    public void deleteObjectMetadata(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null " + this.objectInfo(serverBucket)));
        FileUtils.deleteQuietly((File)new File(this.getObjectMetadataDirPath(serverBucket, string)));
    }

    public String objectInfo(BucketMetadata bucketMetadata) {
        if (bucketMetadata == null) {
            return "b: null";
        }
        return "b_id:" + (bucketMetadata.getId() != null ? bucketMetadata.getId().toString() : "null") + " bn:" + (bucketMetadata.getBucketName() != null ? bucketMetadata.getBucketName() : "null");
    }

    public String objectInfo(Drive drive) {
        if (drive == null) {
            return "d: null";
        }
        return "d:" + drive.getName();
    }

    public String objectInfo(ServerBucket serverBucket) {
        if (serverBucket == null) {
            return "b: null";
        }
        return "b_id:" + (serverBucket.getId() != null ? serverBucket.getId().toString() : "null") + " bn:" + (serverBucket.getName() != null ? serverBucket.getName() : "null");
    }

    private String fileInfo(String string) {
        return "f:" + (string != null ? string : "null") + " d:" + this.getName();
    }

    public String objectInfo(ServerBucket serverBucket, String string) {
        return "bn:" + (serverBucket != null ? serverBucket.getId().toString() : "null") + " o:" + (string != null ? string : "null");
    }

    private String getBucketWorkDirPathById(Long l) {
        return this.getWorkDirPath() + File.separator + l.toString();
    }

    private File getObjectMetadataFileById(Long l, String string) {
        return new File(this.getObjectMetadataFilePathById(l, string));
    }

    private String getBucketMetadataDirPathById(Long l) {
        return this.getBucketsDirPath() + File.separator + l.toString();
    }

    private String getObjectMetadataDirPathById(Long l, String string) {
        return this.getBucketsDirPath() + File.separator + l.toString() + File.separator + string;
    }
}

