/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.odilon.model.BaseObject;
import io.odilon.model.ObjectMetadata;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemObject;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import java.io.IOException;
import java.io.InputStream;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OdilonObject
extends BaseObject
implements VirtualFileSystemObject {
    private ObjectMetadata objectMetadata;
    @JsonIgnore
    private ServerBucket bucket;
    @JsonIgnore
    private String objectName;
    @JsonIgnore
    private VirtualFileSystemService vfs;

    public OdilonObject(ServerBucket serverBucket, String string, VirtualFileSystemService virtualFileSystemService) {
        this.bucket = serverBucket;
        this.objectName = string;
        this.vfs = virtualFileSystemService;
    }

    public ServerBucket getBucket() {
        return this.bucket;
    }

    public ObjectMetadata getObjectMetadata() {
        if (this.objectMetadata == null) {
            this.objectMetadata = this.vfs.getObjectMetadata(this.bucket, this.objectName);
        }
        return this.objectMetadata;
    }

    public int hashCode() {
        return ((this.bucket != null ? this.bucket.getName() : "null") + "$" + this.objectName).hashCode();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public InputStream getInputStream() throws IOException {
        return this.vfs.getObjectStream(this.bucket, this.objectName);
    }
}

