/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.odilon.log.Logger;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.OdilonDrive;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.SimpleDrive;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Component
@Scope(value="prototype")
@NotThreadSafe
public class OdilonSimpleDrive
extends OdilonDrive
implements SimpleDrive {
    private static Logger logger = Logger.getLogger((String)OdilonSimpleDrive.class.getName());

    @Autowired
    protected OdilonSimpleDrive(String string) {
        super(string);
    }

    protected OdilonSimpleDrive(String string, String string2, int n, String string3, int n2) {
        super(string, string2, n, string3, n2);
    }

    public File putObjectStream(Long l, String string, InputStream inputStream) throws IOException {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null -> b:" + l.toString()));
        this.createDataBucketDirIfNotExists(l);
        try {
            ObjectPath objectPath = new ObjectPath((Drive)this, l, string);
            String string2 = objectPath.dataFilePath().toString();
            this.transferTo(inputStream, string2);
            return new File(string2);
        }
        catch (IOException iOException) {
            logger.error(new String[]{iOException.getClass().getName() + " putObjectStream -> b:" + l.toString() + ", o:" + string + ", d:" + this.getName()});
            throw iOException;
        }
    }

    public void putObjectDataFile(Long l, String string, File file) throws IOException {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.putObjectStream(l, string, (InputStream)fileInputStream);
        }
    }

    public void putObjectDataVersionFile(Long l, String string, int n, File file) throws IOException {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            this.putObjectDataVersionStream(l, string, n, (InputStream)bufferedInputStream);
        }
    }

    protected File putObjectDataVersionStream(Long l, String string, int n, InputStream inputStream) throws IOException {
        Check.requireNonNullArgument((Object)l, (String)"bucketId is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null -> b:" + l.toString()));
        try {
            ObjectPath objectPath = new ObjectPath((Drive)this, l, string);
            String string2 = objectPath.dataFileVersionPath(n).toString();
            this.transferTo(inputStream, string2);
            return new File(string2);
        }
        catch (IOException iOException) {
            logger.error(new String[]{iOException.getClass().getName() + " -> b:" + l.toString() + ", o:" + string + ", d:" + this.getName()});
            throw iOException;
        }
    }
}

