/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.odilon.json.OdilonObjectMapper;
import io.odilon.log.Logger;
import io.odilon.model.RedundancyLevel;
import io.odilon.virtualFileSystem.model.JournalService;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;

public class OdilonVirtualFileSystemOperation
implements VirtualFileSystemOperation {
    private static Logger logger = Logger.getLogger((String)OdilonVirtualFileSystemOperation.class.getName());
    @JsonIgnore
    private static ObjectMapper mapper = new OdilonObjectMapper();
    @JsonIgnore
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("YYYY-MM-dd'T'HH:mm:ss.XXX-z", Locale.ENGLISH);
    @JsonIgnore
    private JournalService journalService;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="version")
    private int version;
    @JsonProperty(value="bucketId")
    private Long bucketId;
    @JsonProperty(value="bucketName")
    private String bucketName;
    @JsonProperty(value="objectName")
    private String objectName;
    @JsonProperty(value="timestamp")
    private OffsetDateTime timestamp;
    @JsonProperty(value="operation")
    private OperationCode operationCode;
    @JsonProperty(value="raid")
    private RedundancyLevel raid;
    @JsonProperty(value="replicates")
    private boolean replicates;

    public OdilonVirtualFileSystemOperation() {
    }

    public OdilonVirtualFileSystemOperation(String string, OperationCode operationCode, Optional<Long> optional, Optional<String> optional2, Optional<String> optional3, Optional<Integer> optional4, RedundancyLevel redundancyLevel, JournalService journalService) {
        this.id = string;
        this.operationCode = operationCode;
        if (optional4.isPresent()) {
            this.version = optional4.get();
        }
        if (optional.isPresent()) {
            this.bucketId = optional.get();
        }
        if (optional3.isPresent()) {
            this.objectName = optional3.get();
        }
        if (optional2.isPresent()) {
            this.bucketName = optional2.get();
        }
        this.raid = redundancyLevel;
        this.journalService = journalService;
        this.timestamp = OffsetDateTime.now();
        this.replicates = operationCode.isReplicates();
    }

    public boolean isReplicates() {
        return this.replicates;
    }

    public void setReplicates(boolean bl) {
        this.replicates = bl;
    }

    public Long getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(Long l) {
        this.bucketId = l;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public int getVersion() {
        return this.version;
    }

    public String getUUID() {
        return this.operationCode.getEntityGroupCode() + ":" + (this.bucketId != null ? this.bucketId.toString() : "null") + ":" + (this.objectName != null ? this.objectName : "null");
    }

    protected void setTimestamp(OffsetDateTime offsetDateTime) {
        this.timestamp = offsetDateTime;
    }

    protected void setRedundancyLevel(RedundancyLevel redundancyLevel) {
        this.raid = redundancyLevel;
    }

    public RedundancyLevel getRedundancyLevel() {
        return this.raid;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof OdilonVirtualFileSystemOperation) {
            String string = ((OdilonVirtualFileSystemOperation)object).getId();
            if (this.id == null) {
                return string == null;
            }
            if (string == null) {
                return false;
            }
            return this.id.equals(string);
        }
        return false;
    }

    public String toJSON() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return "\"error\":\"" + exception.getClass().getName() + "\"";
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.toJSON());
        return stringBuilder.toString();
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public OperationCode getOperationCode() {
        return this.operationCode;
    }

    public void setOp(OperationCode operationCode) {
        this.operationCode = operationCode;
    }

    public boolean commit(Object object) {
        return this.getJournalService().commit((VirtualFileSystemOperation)this, object);
    }

    public boolean commit() {
        return this.getJournalService().commit((VirtualFileSystemOperation)this);
    }

    public boolean cancel() {
        return this.getJournalService().cancel((VirtualFileSystemOperation)this);
    }

    public boolean cancel(Object object) {
        return this.getJournalService().cancel((VirtualFileSystemOperation)this, object);
    }

    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }

    public JournalService getJournalService() {
        return this.journalService;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setOperationCode(OperationCode operationCode) {
        this.operationCode = operationCode;
    }
}

