/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.OdilonApplication;
import io.odilon.cache.FileCacheService;
import io.odilon.cache.ObjectMetadataCacheService;
import io.odilon.encryption.EncryptionService;
import io.odilon.encryption.MasterKeyService;
import io.odilon.encryption.OdilonKeyEncryptorService;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.RedundancyLevel;
import io.odilon.model.ServiceStatus;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.monitor.SystemMonitorService;
import io.odilon.query.BucketIteratorService;
import io.odilon.query.OdilonBucketIteratorService;
import io.odilon.replication.ReplicationService;
import io.odilon.scheduler.SchedulerService;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.service.BaseService;
import io.odilon.service.ServerSettings;
import io.odilon.service.util.ByteToString;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.Action;
import io.odilon.virtualFileSystem.BaseIODriver;
import io.odilon.virtualFileSystem.BucketCache;
import io.odilon.virtualFileSystem.BucketEvent;
import io.odilon.virtualFileSystem.DriveInfo;
import io.odilon.virtualFileSystem.EncryptionInitializer;
import io.odilon.virtualFileSystem.OdilonBucket;
import io.odilon.virtualFileSystem.OdilonDrive;
import io.odilon.virtualFileSystem.OdilonJournalService;
import io.odilon.virtualFileSystem.OdilonSimpleDrive;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.DriveBucket;
import io.odilon.virtualFileSystem.model.DriveStatus;
import io.odilon.virtualFileSystem.model.IODriver;
import io.odilon.virtualFileSystem.model.JournalService;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemObject;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import io.odilon.virtualFileSystem.raid6.BufferPoolService;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

@Service
@ThreadSafe
public class OdilonVirtualFileSystemService
extends BaseService
implements VirtualFileSystemService,
ApplicationContextAware,
ApplicationListener<BucketEvent> {
    private static Logger logger = Logger.getLogger((String)OdilonVirtualFileSystemService.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    private static final String MAC_ALGORITHM = "HmacSHA256";
    @JsonIgnore
    @Autowired
    private final BufferPoolService bufferPoolService;
    @JsonIgnore
    @Autowired
    private final SchedulerService schedulerService;
    @JsonIgnore
    @Autowired
    private final ServerSettings serverSettings;
    @JsonIgnore
    @Autowired
    private final EncryptionService encrpytionService;
    @JsonIgnore
    @Autowired
    private final SystemMonitorService monitoringService;
    @JsonIgnore
    @Autowired
    private final ObjectMetadataCacheService objectCacheService;
    @JsonIgnore
    @Autowired
    private final LockService lockService;
    @JsonIgnore
    @Autowired
    private final JournalService journalService;
    @JsonIgnore
    @Autowired
    private final BucketIteratorService bucketIteratorService;
    @JsonIgnore
    @Autowired
    private final ReplicationService replicationService;
    @JsonIgnore
    @Autowired
    private final MasterKeyService masterKeyEncryptorService;
    @JsonIgnore
    @Autowired
    private final OdilonKeyEncryptorService odilonKeyEncryptorService;
    @Autowired
    @JsonIgnore
    private final ApplicationEventPublisher applicationEventPublisher;
    @JsonIgnore
    @Autowired
    private final FileCacheService fileCacheService;
    @JsonProperty(value="started")
    private final OffsetDateTime started = OffsetDateTime.now();
    @JsonProperty(value="raid")
    private final RedundancyLevel raid;
    @JsonIgnore
    private AtomicLong bucketIdGenerator;
    @JsonIgnore
    private Optional<String> providedMasterKey = Optional.empty();
    @JsonIgnore
    private final ExecutorService fileExecutorService;
    @JsonIgnore
    private Map<String, Drive> drivesAll = new ConcurrentHashMap();
    @JsonIgnore
    private Map<String, Drive> drivesEnabled = new ConcurrentHashMap();
    @JsonIgnore
    private final Map<Integer, Drive> drivesRSDecode = new ConcurrentHashMap();
    @JsonIgnore
    private ApplicationContext applicationContext;
    @JsonIgnore
    private BucketCache bucketCache = new BucketCache();

    @Autowired
    public OdilonVirtualFileSystemService(ServerSettings serverSettings, SystemMonitorService systemMonitorService, EncryptionService encryptionService, LockService lockService, JournalService journalService, SchedulerService schedulerService, BucketIteratorService bucketIteratorService, ReplicationService replicationService, ObjectMetadataCacheService objectMetadataCacheService, MasterKeyService masterKeyService, OdilonKeyEncryptorService odilonKeyEncryptorService, FileCacheService fileCacheService, BufferPoolService bufferPoolService, ApplicationEventPublisher applicationEventPublisher) {
        this.bufferPoolService = bufferPoolService;
        this.fileCacheService = fileCacheService;
        this.objectCacheService = objectMetadataCacheService;
        this.lockService = lockService;
        this.serverSettings = serverSettings;
        this.monitoringService = systemMonitorService;
        this.encrpytionService = encryptionService;
        this.journalService = journalService;
        this.schedulerService = schedulerService;
        this.bucketIteratorService = bucketIteratorService;
        this.replicationService = replicationService;
        this.masterKeyEncryptorService = masterKeyService;
        this.odilonKeyEncryptorService = odilonKeyEncryptorService;
        this.applicationEventPublisher = applicationEventPublisher;
        this.raid = serverSettings.getRedundancyLevel();
        this.fileExecutorService = Executors.newCachedThreadPool();
    }

    public List<ObjectMetadata> getObjectMetadataAllVersions(String string, String string2) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.getObjectMetadataVersionAll(iODriver.getBucket(string), string2);
    }

    public ObjectMetadata getObjectMetadataVersion(String string, String string2, int n) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.getObjectMetadataVersion(iODriver.getBucket(string), string2, n);
    }

    public ObjectMetadata getObjectMetadataPreviousVersion(String string, String string2) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.getObjectMetadataPreviousVersion(iODriver.getBucket(string), string2);
    }

    public InputStream getObjectVersion(String string, String string2, int n) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        Check.requireTrue((n >= 0 ? 1 : 0) != 0, (String)"version must be >=0");
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.getObjectVersionInputStream(iODriver.getBucket(string), string2, n);
    }

    public boolean hasVersions(String string, String string2) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.hasVersions(iODriver.getBucket(string), string2);
    }

    public void deleteObjectAllPreviousVersions(String string, String string2) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        iODriver.deleteObjectAllPreviousVersions(iODriver.getBucket(string), string2);
    }

    public void deleteBucketAllPreviousVersions(String string) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        iODriver.deleteBucketAllPreviousVersions(iODriver.getBucket(string));
    }

    public void wipeAllPreviousVersions() {
        this.createVFSIODriver().wipeAllPreviousVersions();
    }

    public ObjectMetadata restorePreviousVersion(String string, String string2) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.restorePreviousVersion(iODriver.getBucket(string), string2);
    }

    public ServerBucket createBucket(String string) throws IOException {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        return this.createVFSIODriver().createBucket(string);
    }

    public ServerBucket renameBucketName(String string, String string2) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)"newBucketName can not be null or empty");
        if (!string2.matches("[A-Za-z0-9\\-_]+")) {
            throw new IllegalArgumentException("bucketName contains invalid character | regular expression is -> [A-Za-z0-9\\-_]+ |  b:" + string2);
        }
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.renameBucket(iODriver.getBucket(string), string2);
    }

    public void removeBucket(String string) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        iODriver.removeBucket(iODriver.getBucket(string), false);
    }

    public void forceRemoveBucket(String string) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        iODriver.removeBucket(iODriver.getBucket(string), true);
    }

    public boolean existsBucket(String string) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        return this.createVFSIODriver().existsBucket(string);
    }

    public boolean isEmptyBucket(String string) {
        Check.requireNonNullArgument((Object)string, (String)"bucketName can not be null or empty");
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.isEmpty(iODriver.getBucket(string));
    }

    public boolean isEmpty(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket can not be null");
        return this.createVFSIODriver().isEmpty(serverBucket);
    }

    public void putObject(ServerBucket serverBucket, String string, File file) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket can not be null");
        this.createVFSIODriver().putObject(serverBucket, string, file);
    }

    public void putObject(ServerBucket serverBucket, String string, InputStream inputStream, String string2, String string3) {
        this.putObject(serverBucket, string, inputStream, string2, string3, Optional.empty());
    }

    public void putObject(String string, String string2, InputStream inputStream, String string3, String string4, Optional<List<String>> optional) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullArgument((Object)string2, (String)("objectName can not be null -> b:" + string));
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        this.putObject(iODriver.getBucket(string), string2, inputStream, string3, string4, optional);
    }

    public void putObject(ServerBucket serverBucket, String string, InputStream inputStream, String string2, String string3, Optional<List<String>> optional) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket can not be null ");
        Check.requireNonNullArgument((Object)string, (String)("objectName can not be null -> b:" + serverBucket.getName()));
        this.createVFSIODriver().putObject(serverBucket, string, inputStream, string2, string3, optional);
    }

    public VirtualFileSystemObject getObject(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket can not be null ");
        Check.requireNonNullArgument((Object)string, (String)("objectName can not be null -> b:" + serverBucket.getName()));
        return this.createVFSIODriver().getObject(serverBucket, string);
    }

    public VirtualFileSystemObject getObject(String string, String string2) {
        Check.requireNonNullArgument((Object)string, (String)"bucketName can not be null");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.getObject(iODriver.getBucket(string), string2);
    }

    public InputStream getObjectStream(ServerBucket serverBucket, String string) throws IOException {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket can not be null ");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null or empty | b:" + serverBucket.getName()));
        return this.createVFSIODriver().getInputStream(serverBucket, string);
    }

    public InputStream getObjectStream(String string, String string2) throws IOException {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return this.getObjectStream(iODriver.getBucket(string), string2);
    }

    public DataList<Item<ObjectMetadata>> listObjects(String string) {
        return this.listObjects(string, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public DataList<Item<ObjectMetadata>> listObjects(String string, Optional<Long> optional, Optional<Integer> optional2, Optional<String> optional3, Optional<String> optional4) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.listObjects(iODriver.getBucket(string), optional, optional2, optional3, optional4);
    }

    public ObjectMetadata getObjectMetadata(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket can not be null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null or empty | b:" + serverBucket.getName()));
        return this.createVFSIODriver().getObjectMetadata(serverBucket, string);
    }

    public boolean existsObject(String string, String string2) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        Check.requireNonNullStringArgument((String)string2, (String)("objectName can not be null or empty | b:" + string));
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.exists(iODriver.getBucket(string), string2);
    }

    public boolean existsObject(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket can not be null ");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null or empty | b:" + serverBucket.getName()));
        return this.createVFSIODriver().exists(serverBucket, string);
    }

    public ServerBucket getBucketByName(String string) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName can not be null or empty");
        IODriver iODriver = this.createVFSIODriver();
        Check.requireTrue((boolean)iODriver.existsBucket(string), (String)("bucket does not exist -> " + string));
        return iODriver.getBucket(string);
    }

    public void deleteObject(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket can not be null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null or empty | b:" + serverBucket.getName()));
        this.createVFSIODriver().delete(serverBucket, string);
    }

    public Map<String, Drive> getMapDrivesEnabled() {
        return this.drivesEnabled;
    }

    public Map<String, Drive> getMapDrivesAll() {
        return this.drivesAll;
    }

    public Map<Integer, Drive> getMapDrivesRSDecode() {
        return this.drivesRSDecode;
    }

    public synchronized void updateDriveStatus(Drive drive) {
        if (drive.getDriveInfo().getStatus() == DriveStatus.ENABLED) {
            this.getMapDrivesEnabled().put(drive.getName(), drive);
            this.getMapDrivesRSDecode().put(drive.getDriveInfo().getOrder(), drive);
        } else {
            this.getMapDrivesEnabled().remove(drive.getName(), drive);
            this.getMapDrivesRSDecode().remove(drive.getDriveInfo().getOrder(), drive);
        }
    }

    public boolean isEncrypt() {
        return this.getServerSettings().isEncryptionEnabled();
    }

    public boolean isUseVaultNewFiles() {
        return this.getServerSettings().isUseVaultNewFiles();
    }

    public EncryptionService getEncryptionService() {
        return this.encrpytionService;
    }

    public JournalService getJournalService() {
        return this.journalService;
    }

    public FileCacheService getFileCacheService() {
        return this.fileCacheService;
    }

    public ObjectMetadataCacheService getObjectMetadataCacheService() {
        return this.objectCacheService;
    }

    public RedundancyLevel getRedundancyLevel() {
        return this.raid;
    }

    public IODriver createVFSIODriver() {
        if (this.raid == RedundancyLevel.RAID_0) {
            return (IODriver)this.getApplicationContext().getBean(RAIDZeroDriver.class, new Object[]{this, this.getLockService()});
        }
        if (this.raid == RedundancyLevel.RAID_1) {
            return (IODriver)this.getApplicationContext().getBean(RAIDOneDriver.class, new Object[]{this, this.getLockService()});
        }
        if (this.raid == RedundancyLevel.RAID_6) {
            return (IODriver)this.getApplicationContext().getBean(RAIDSixDriver.class, new Object[]{this, this.getLockService()});
        }
        throw new IllegalStateException("RAID not supported -> " + this.raid.toString());
    }

    public List<VirtualFileSystemOperation> getJournalPendingOperations() {
        return this.createVFSIODriver().getJournalPending(this.getJournalService());
    }

    public List<ServiceRequest> getSchedulerPendingRequests(String string) {
        return this.createVFSIODriver().getSchedulerPendingRequests(string);
    }

    public void saveScheduler(ServiceRequest serviceRequest, String string) {
        Check.requireNonNullArgument((Object)serviceRequest, (String)"request can not be null");
        this.createVFSIODriver().saveScheduler(serviceRequest, string);
    }

    public void removeScheduler(ServiceRequest serviceRequest, String string) {
        Check.requireNonNullArgument((Object)serviceRequest, (String)"request can not be null");
        this.createVFSIODriver().removeScheduler(serviceRequest, string);
    }

    public void removeJournal(String string) {
        Check.requireNonNullArgument((Object)string, (String)"id can not be null");
        this.createVFSIODriver().removeJournal(string);
    }

    public void saveJournal(VirtualFileSystemOperation virtualFileSystemOperation) {
        Check.requireNonNullArgument((Object)virtualFileSystemOperation, (String)"op is null");
        this.createVFSIODriver().saveJournal(virtualFileSystemOperation);
    }

    public OffsetDateTime getStarted() {
        return this.started;
    }

    public List<ServerBucket> listAllBuckets() {
        ArrayList<ServerBucket> arrayList = new ArrayList<ServerBucket>();
        HashMap<String, ServerBucket> hashMap = new HashMap<String, ServerBucket>();
        for (Map.Entry entry : this.getMapDrivesEnabled().entrySet()) {
            List list = ((Drive)entry.getValue()).getBuckets();
            list.forEach(driveBucket -> hashMap.put(driveBucket.getName(), (ServerBucket)new OdilonBucket(driveBucket)));
        }
        hashMap.forEach((string, serverBucket) -> arrayList.add((ServerBucket)serverBucket));
        return arrayList;
    }

    public boolean checkIntegrity(String string, String string2, boolean bl) {
        Check.requireNonNullStringArgument((String)string, (String)"bucketName is null");
        IODriver iODriver = this.createVFSIODriver();
        return iODriver.checkIntegrity(iODriver.getBucket(string), string2, bl);
    }

    public BucketIteratorService getBucketIteratorService() {
        return this.bucketIteratorService;
    }

    public Long getNextBucketId() {
        return this.getBucketIdGenerator().addAndGet(1L);
    }

    public byte[] HMAC(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, MAC_ALGORITHM);
        Mac mac = Mac.getInstance(MAC_ALGORITHM);
        mac.init(secretKeySpec);
        return mac.doFinal(byArray);
    }

    public String ping() {
        StringBuilder stringBuilder = new StringBuilder();
        this.drivesEnabled.forEach((string, drive) -> {
            if (!drive.ping().equals("ok")) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" | ");
                }
                stringBuilder.append(string + "->" + drive.ping());
            }
        });
        return stringBuilder.length() > 0 ? stringBuilder.toString() : "ok";
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public BufferPoolService getBufferPoolService() {
        return this.bufferPoolService;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "{");
        stringBuilder.append(this.toJSON());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String toJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"redundancy\":" + (String)(Optional.ofNullable(this.raid).isPresent() ? "\"" + this.raid.getName() + "\"" : "null"));
        stringBuilder.append(", \"drive\":[");
        int n = 0;
        for (Map.Entry entry : this.getMapDrivesEnabled().entrySet()) {
            stringBuilder.append((n > 0 ? ", " : "") + "{\"name\":\"" + (String)entry.getKey() + "\", \"mount\": \"" + ((Drive)entry.getValue()).getRootDirPath() + "\"}");
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(BucketEvent bucketEvent) {
        if (bucketEvent.getAction() == Action.COMMIT && bucketEvent.getOperation().getOperationCode() == OperationCode.CREATE_BUCKET) {
            ServerBucket serverBucket = bucketEvent.getBucket();
            this.getBucketCache().add(serverBucket);
            return;
        }
        if (bucketEvent.getAction() == Action.COMMIT && bucketEvent.getOperation().getOperationCode() == OperationCode.UPDATE_BUCKET) {
            ServerBucket serverBucket = bucketEvent.getBucket();
            this.getBucketCache().update(bucketEvent.getOperation().getBucketName(), serverBucket);
            return;
        }
        if (bucketEvent.getAction() == Action.COMMIT && bucketEvent.getOperation().getOperationCode() == OperationCode.DELETE_BUCKET) {
            ServerBucket serverBucket = bucketEvent.getBucket();
            this.getBucketCache().remove(serverBucket);
            return;
        }
    }

    public OdilonServerInfo getOdilonServerInfo() {
        return this.createVFSIODriver().getServerInfo();
    }

    public void setOdilonServerInfo(OdilonServerInfo odilonServerInfo) {
        Check.requireNonNullArgument((Object)odilonServerInfo, (String)"serverInfo can not be null");
        this.createVFSIODriver().setServerInfo(odilonServerInfo);
    }

    public ReplicationService getReplicationService() {
        return this.replicationService;
    }

    public MasterKeyService getMasterKeyEncryptorService() {
        return this.masterKeyEncryptorService;
    }

    public SystemMonitorService getSystemMonitorService() {
        return this.monitoringService;
    }

    public LockService getLockService() {
        return this.lockService;
    }

    public ExecutorService getExecutorService() {
        return this.fileExecutorService;
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public BucketCache getBucketCache() {
        return this.bucketCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    protected void onInitialize() {
        OdilonVirtualFileSystemService odilonVirtualFileSystemService = this;
        synchronized (odilonVirtualFileSystemService) {
            this.setStatus(ServiceStatus.STARTING);
            try {
                this.lazyInjection();
                this.loadDrives();
                this.loadBuckets();
                startuplogger.info("---------------------------------");
                this.loadMasterKey();
                this.getSchedulerService().start();
                this.processJournalQueue(true);
                this.deleteGhostsBuckets();
                this.checkDriveBuckets();
                this.setUpNewDrives();
                this.checkServerInfo();
                this.cleanUpWorkDir();
                if (this.getSchedulerService().getStandardQueueSize() > 0) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {
                        logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    }
                }
                this.setStatus(ServiceStatus.RUNNING);
            }
            catch (Exception exception) {
                this.setStatus(ServiceStatus.STOPPED);
                throw exception;
            }
        }
    }

    private Optional<String> getProvidedMasterKey() {
        return this.providedMasterKey;
    }

    private void loadDrives() {
        Drive drive2;
        ArrayList<Drive> arrayList = new ArrayList<Drive>();
        int n2 = 0;
        this.drivesAll.clear();
        this.drivesEnabled.clear();
        this.drivesRSDecode.clear();
        for (String object : this.getServerSettings().getRootDirs()) {
            drive2 = null;
            if (this.getRedundancyLevel() == RedundancyLevel.RAID_6) {
                drive2 = new OdilonDrive(String.valueOf(n2), object, n2, this.getRedundancyLevel().getName(), this.getServerSettings().getTotalDisks());
                ++n2;
            } else {
                drive2 = new OdilonSimpleDrive(String.valueOf(n2), object, n2, this.getRedundancyLevel().getName(), this.getServerSettings().getTotalDisks());
                ++n2;
            }
            arrayList.add(drive2);
            this.drivesAll.put(drive2.getName(), drive2);
            if (drive2.getDriveInfo().getStatus() != DriveStatus.ENABLED) continue;
            this.drivesEnabled.put(drive2.getName(), drive2);
        }
        n2 = 1;
        for (Map.Entry entry : this.drivesAll.entrySet()) {
            drive2 = (Drive)entry.getValue();
            if (drive2.getDriveInfo().getStatus() == DriveStatus.NOTSYNC) continue;
            n2 = 0;
            break;
        }
        if (n2 != 0) {
            this.drivesEnabled.clear();
            for (Drive drive3 : arrayList) {
                drive2 = drive3.getDriveInfo();
                drive2.setOrder(drive3.getConfigOrder());
                drive2.setStatus(DriveStatus.ENABLED);
                drive3.setDriveInfo((DriveInfo)drive2);
                this.drivesEnabled.put(drive3.getName(), drive3);
            }
        }
        this.drivesEnabled.values().forEach(drive -> this.drivesRSDecode.put(drive.getDriveInfo().getOrder(), drive));
        if (logger.isDebugEnabled()) {
            logger.debug("---------------------------------");
            logger.debug("Drives enabled");
            this.drivesEnabled.forEach((string, drive) -> logger.debug(drive.getRootDirPath()));
            logger.debug("---------------------------------");
            logger.debug("Drives used for Reed Solomon decode");
            this.drivesRSDecode.forEach((n, drive) -> logger.debug(n.toString() + " -> " + drive.getRootDirPath()));
            logger.debug("---------------------------------");
        }
    }

    private void deleteGhostsBuckets() {
        for (Map.Entry entry : this.getMapDrivesAll().entrySet()) {
            Drive drive = (Drive)entry.getValue();
            List list = drive.getBuckets();
            for (DriveBucket driveBucket : list) {
                if (!driveBucket.isDeleted()) continue;
                logger.debug("Deleting ghost bucket -> b:" + driveBucket.getName() + " d:" + drive.getName());
                ((OdilonDrive)drive).forceDeleteBucketById(driveBucket.getId());
            }
        }
    }

    private synchronized void loadBuckets() {
        Map map = ((BaseIODriver)this.createVFSIODriver()).getBucketsMap();
        if (map.size() == 0) {
            startuplogger.debug("Adding buckets to cache -> ok (no buckets)");
        } else {
            map.forEach((string, serverBucket) -> this.bucketCache.getNameMap().put(string, serverBucket));
            map.forEach((string, serverBucket) -> this.bucketCache.getIdMap().put(serverBucket.getId(), serverBucket));
            startuplogger.debug("Adding buckets to cache -> ok (" + String.valueOf(map.size()) + ")");
        }
        map.values().forEach(serverBucket -> {
            if (serverBucket.getId() == null) {
                serverBucket.getBucketMetadata().id = 0L;
            }
        });
        if (map.size() > 0) {
            this.bucketIdGenerator = new AtomicLong(map.values().stream().mapToLong(serverBucket -> serverBucket.getId()).max().orElseThrow(IllegalStateException::new));
        }
        if (this.bucketIdGenerator == null || this.getBucketIdGenerator().get() < 1L) {
            this.bucketIdGenerator = new AtomicLong(0L);
        }
        map.values().forEach(serverBucket -> {
            if (serverBucket.getId() == 0L) {
                serverBucket.getBucketMetadata().id = this.getNextBucketId();
                logger.debug("save bucket -> " + serverBucket.getName());
            }
        });
    }

    private void checkDriveBuckets() {
        block9: {
            try {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (Map.Entry object2 : this.getMapDrivesEnabled().entrySet()) {
                    Drive n2 = (Drive)object2.getValue();
                    List interruptedException = n2.getBuckets();
                    Iterator iterator = interruptedException.iterator();
                    while (iterator.hasNext()) {
                        DriveBucket driveBucket = (DriveBucket)iterator.next();
                        if (!driveBucket.isAccesible()) continue;
                        if (hashMap.containsKey(driveBucket.getName())) {
                            Integer n = (Integer)hashMap.get(driveBucket.getName());
                            n = n + Integer.valueOf(1);
                            hashMap.put(driveBucket.getName(), n);
                            continue;
                        }
                        hashMap.put(driveBucket.getName(), 1);
                    }
                }
                int n = this.getMapDrivesEnabled().size();
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                int n2 = hashMap.size();
                for (Map.Entry entry : hashMap.entrySet()) {
                    if ((Integer)entry.getValue() >= n) continue;
                    arrayList.add((CallSite)((Object)("Error with Bucket -> " + (String)entry.getKey() + " | count -> " + String.valueOf(entry.getValue()) + " / " + n)));
                }
                if (arrayList.size() > 0) {
                    arrayList.forEach(string -> startuplogger.error(new String[]{string.toString()}));
                    startuplogger.error(new String[]{"----------------------------------------------------"});
                    startuplogger.error(new String[]{"Structure Check -> Total errors " + arrayList.size()});
                    startuplogger.error(new String[]{"The server is in inconsistent state and can not run"});
                    startuplogger.error(new String[]{"Exiting"});
                    startuplogger.error(new String[]{"----------------------------------------------------"});
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ((ConfigurableApplicationContext)this.getApplicationContext()).close();
                    System.exit(1);
                    break block9;
                }
                startuplogger.debug("Structure check -> ok (d:" + String.valueOf(n) + " | b:" + String.valueOf(n2) + ")");
            }
            catch (Exception exception) {
                logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                throw exception;
            }
        }
    }

    private void setUpNewDrives() {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : this.getMapDrivesAll().entrySet()) {
            Drive drive = (Drive)entry.getValue();
            if (drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC) continue;
            arrayList.add(drive.getRootDirPath());
            bl = true;
        }
        if (!bl) {
            return;
        }
        startuplogger.info("Setting up new drives:");
        arrayList.forEach(string -> startuplogger.info(string));
        startuplogger.info("---------------");
        this.createVFSIODriver().setUpDrives();
    }

    private void lazyInjection() {
        this.getLockService().setVirtualFileSystemService(this);
        this.getFileCacheService().setVirtualFileSystemService((VirtualFileSystemService)this);
        ((OdilonBucketIteratorService)this.getBucketIteratorService()).setVirtualFileSystemService((VirtualFileSystemService)this);
        ((OdilonJournalService)this.getJournalService()).setVirtualFileSystemService((VirtualFileSystemService)this);
        this.getReplicationService().setVirtualFileSystemService((VirtualFileSystemService)this);
        this.getSchedulerService().setVirtualFileSystemService((VirtualFileSystemService)this);
    }

    private synchronized void processJournalQueue(boolean bl) {
        List list = this.getJournalPendingOperations();
        if (list == null || list.isEmpty()) {
            return;
        }
        logger.debug("Processing Journal queue -> " + String.valueOf(list.size()));
        IODriver iODriver = this.createVFSIODriver();
        for (VirtualFileSystemOperation virtualFileSystemOperation : list) {
            iODriver.rollback(virtualFileSystemOperation, bl);
        }
    }

    private void checkServerInfo() {
        IODriver iODriver = this.createVFSIODriver();
        OdilonServerInfo odilonServerInfo = iODriver.getServerInfo();
        if (odilonServerInfo == null) {
            iODriver.setServerInfo(this.getServerSettings().getDefaultOdilonServerInfo());
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.getServerSettings().isStandByEnabled() && !odilonServerInfo.isStandByEnabled();
        boolean bl4 = this.getServerSettings().isVersionControl() && !odilonServerInfo.isVersionControl();
        boolean bl5 = false;
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        if (bl4) {
            odilonServerInfo.setVersionControlDate(offsetDateTime);
            bl = true;
        }
        if (odilonServerInfo.getServerMode() == null || !odilonServerInfo.getServerMode().equals(this.getServerSettings().getServerMode())) {
            odilonServerInfo.setServerMode(this.getServerSettings().getServerMode());
            bl = true;
        }
        if (odilonServerInfo.isStandByEnabled() != this.getServerSettings().isStandByEnabled()) {
            bl = true;
        }
        if (!this.getServerSettings().isStandByEnabled() && odilonServerInfo.getStandByStartDate() != null) {
            odilonServerInfo.setStandByStartDate(null);
            odilonServerInfo.setStandBySyncedDate(null);
            bl = true;
        }
        if (odilonServerInfo.getStandbyUrl() != null && this.getServerSettings().getStandbyUrl() == null) {
            bl = true;
            odilonServerInfo.setStandByStartDate(null);
            odilonServerInfo.setStandBySyncedDate(null);
        } else if (odilonServerInfo.getStandbyUrl() == null && this.getServerSettings().getStandbyUrl() != null) {
            bl = true;
            odilonServerInfo.setStandByStartDate(offsetDateTime);
            odilonServerInfo.setStandBySyncedDate(null);
        } else if (odilonServerInfo.getStandbyUrl() != null && this.getServerSettings().getStandbyUrl() != null) {
            int n;
            int n2 = (this.getServerSettings().getStandbyUrl().trim().toLowerCase() + String.valueOf(this.getServerSettings().getStandbyPort())).hashCode();
            bl5 = n2 != (n = (odilonServerInfo.getStandbyUrl().trim().toLowerCase() + String.valueOf(odilonServerInfo.getStandbyPort())).hashCode());
        }
        bl2 = this.getServerSettings().isStandbySyncForce();
        if (bl3 || bl5 || bl2) {
            odilonServerInfo.setStandByStartDate(offsetDateTime);
            odilonServerInfo.setStandBySyncedDate(null);
            bl = true;
        }
        if (!bl && odilonServerInfo.getServerMode() != null && this.getServerSettings().getServerMode() != null && !odilonServerInfo.getServerMode().equals(this.getServerSettings().getServerMode())) {
            bl = true;
        }
        if (!bl && odilonServerInfo.getStandbyUrl() != null && this.getServerSettings().getStandByUrl() != null && !odilonServerInfo.getStandbyUrl().equals(this.getServerSettings().getStandByUrl())) {
            bl = true;
        }
        if (!bl && odilonServerInfo.getStandbyPort() != this.getServerSettings().getStandbyPort()) {
            bl = true;
        }
        if (bl) {
            odilonServerInfo.setServerMode(this.getServerSettings().getServerMode());
            odilonServerInfo.setStandbyPort(this.getServerSettings().getStandbyPort());
            odilonServerInfo.setStandbyUrl(this.getServerSettings().getStandByUrl());
            odilonServerInfo.setStandByEnabled(this.getServerSettings().isStandByEnabled());
            odilonServerInfo.setVersionControl(this.getServerSettings().isVersionControl());
            iODriver.setServerInfo(odilonServerInfo);
        }
    }

    private synchronized void cleanUpWorkDir() {
        try {
            this.getMapDrivesAll().values().forEach(drive -> {
                for (ServerBucket serverBucket : this.listAllBuckets()) {
                    drive.cleanUpWorkDir(serverBucket);
                    drive.cleanUpCacheDir(serverBucket);
                }
            });
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private boolean isLinux() {
        return System.getenv("OS") == null || !System.getenv("OS").toLowerCase().contains("windows");
    }

    private void loadMasterKey() {
        Object object;
        boolean bl = false;
        for (String string : OdilonApplication.cmdArgs) {
            String string2;
            String string3;
            String[] stringArray;
            String string4 = string.toLowerCase().trim().replace(" ", "");
            if (string4.equals("-dinitializeencryption=true") || string4.equals("--initializeencryption=true")) {
                bl = true;
            }
            if (!string4.startsWith("-dmasterkey=") && !string4.equals("--masterkey=") || (stringArray = (string3 = string.trim()).split(string2 = string.trim().startsWith("-DmasterKey=") ? "-DmasterKey=" : "--masterKey=")).length <= 1) continue;
            this.providedMasterKey = Optional.of(stringArray[1]);
        }
        if (bl) {
            object = new EncryptionInitializer((VirtualFileSystemService)this, this.getProvidedMasterKey());
            object.execute();
            return;
        }
        if (!this.getServerSettings().isEncryptionEnabled()) {
            return;
        }
        if (this.getServerSettings().getEncryptionKey() == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("\n---------------------------------\n");
            ((StringBuilder)object).append("odilon.properties:\n");
            ((StringBuilder)object).append("encrypt=true but encryption.key is null\n");
            ((StringBuilder)object).append("The Encryption key is required to use encryption.\n");
            ((StringBuilder)object).append("It is generated when the encryption service is initialized.\n");
            ((StringBuilder)object).append("If the encryption service has not been initialized please run the script -> " + this.getEnableEncryptionScriptName() + "\n");
            ((StringBuilder)object).append("---------------------------------\n\n");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        if (this.getServerSettings().getInternalMasterKeyEncryptor() != null) {
            startuplogger.info("MASTER KEY");
            startuplogger.info("----------");
            startuplogger.info("Master Key is overriden by variable 'encryption.masterKey' in 'odilon.properties'.");
            startuplogger.info("Master Key from -> odilon.properties");
            startuplogger.info("---------------------------------");
            object = this.getServerSettings().getInternalMasterKeyEncryptor();
            byte[] byArray = ByteToString.hexStringToByte((String)object);
            this.getKeyEncryptorService().setMasterKey(byArray);
            return;
        }
        object = this.createVFSIODriver();
        OdilonServerInfo odilonServerInfo = object.getServerInfo();
        if (odilonServerInfo == null) {
            odilonServerInfo = this.getServerSettings().getDefaultOdilonServerInfo();
        }
        if (!odilonServerInfo.isEncryptionIntialized()) {
            EncryptionInitializer encryptionInitializer = new EncryptionInitializer((VirtualFileSystemService)this, this.getProvidedMasterKey());
            encryptionInitializer.notInitializedError();
            return;
        }
        try {
            byte[] byArray = object.getServerMasterKey();
            this.getKeyEncryptorService().setMasterKey(byArray);
        }
        catch (Exception exception) {
            logger.error(new String[]{exception.getClass().getName() + " | " + exception.getMessage(), "---- not thrown ----"});
            throw new InternalCriticalException(exception, "error with encryption key");
        }
    }

    private String getEnableEncryptionScriptName() {
        return this.isLinux() ? "enable-encryption.sh" : "enable-encryption.bat";
    }

    private AtomicLong getBucketIdGenerator() {
        return this.bucketIdGenerator;
    }

    private OdilonKeyEncryptorService getKeyEncryptorService() {
        return this.odilonKeyEncryptorService;
    }
}

