/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.model;

import io.odilon.model.BucketMetadata;
import io.odilon.model.ObjectMetadata;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.virtualFileSystem.DriveInfo;
import io.odilon.virtualFileSystem.model.DriveBucket;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import java.io.File;
import java.io.IOException;
import java.util.List;

public interface Drive {
    public DriveInfo getDriveInfo();

    public void setDriveInfo(DriveInfo var1);

    public void saveJournal(VirtualFileSystemOperation var1);

    public void removeJournal(String var1);

    public void putSysFile(String var1, String var2);

    public File getSysFile(String var1);

    public void removeSysFile(String var1);

    public int getConfigOrder();

    public String getRootDirPath();

    public String getSysDirPath();

    public String getBucketsDirPath();

    public String getCacheDirPath();

    public String getWorkDirPath();

    public String getJournalDirPath();

    public String getTempDirPath();

    public String getSchedulerDirPath();

    public String ping();

    public long getTotalSpace();

    public long getAvailableSpace();

    public String getName();

    public void saveScheduler(ServiceRequest var1, String var2);

    public void removeScheduler(ServiceRequest var1, String var2);

    public List<File> getSchedulerRequests(String var1);

    public BucketMetadata getBucketMetadataById(Long var1) throws IOException;

    public boolean existsBucketById(Long var1);

    public BucketMetadata getBucketMetadata(ServerBucket var1) throws IOException;

    public File createBucket(BucketMetadata var1) throws IOException;

    public void updateBucket(BucketMetadata var1) throws IOException;

    public void deleteBucket(ServerBucket var1);

    public List<DriveBucket> getBuckets();

    public void markAsDeletedBucket(ServerBucket var1);

    public void markAsEnabledBucket(ServerBucket var1);

    public boolean isEmpty(ServerBucket var1);

    public String getBucketMetadataDirPath(ServerBucket var1);

    public String getBucketObjectDataDirPath(ServerBucket var1);

    public String getBucketWorkDirPath(ServerBucket var1);

    public String getBucketCacheDirPath(ServerBucket var1);

    public void cleanUpWorkDir(ServerBucket var1);

    public void cleanUpCacheDir(ServerBucket var1);

    public boolean existsObjectMetadata(ServerBucket var1, String var2);

    public boolean existsObjectMetadata(ObjectMetadata var1);

    public void markAsDeletedObject(ServerBucket var1, String var2);

    public String getObjectMetadataDirPath(ServerBucket var1, String var2);

    public ObjectMetadata getObjectMetadata(ServerBucket var1, String var2);

    public void deleteObjectMetadata(ServerBucket var1, String var2);

    public void saveObjectMetadata(ObjectMetadata var1);

    public File getObjectMetadataFile(ServerBucket var1, String var2);

    public void putObjectMetadataFile(ServerBucket var1, String var2, File var3) throws IOException;

    public void saveObjectMetadataVersion(ObjectMetadata var1);

    public ObjectMetadata getObjectMetadataVersion(ServerBucket var1, String var2, int var3);

    public File getObjectMetadataVersionFile(ServerBucket var1, String var2, int var3);

    public void putObjectMetadataVersionFile(ServerBucket var1, String var2, int var3, File var4) throws IOException;
}

