/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid0.RAIDZeroTransactionObjectHandler;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RAIDZeroCreateObjectHandler
extends RAIDZeroTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDZeroCreateObjectHandler.class.getName());

    protected RAIDZeroCreateObjectHandler(RAIDZeroDriver rAIDZeroDriver, ServerBucket serverBucket, String string) {
        super(rAIDZeroDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void create(InputStream inputStream, String string, String string2, Optional<List<String>> optional) {
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl = false;
        boolean bl2 = false;
        this.objectWriteLock();
        try {
            this.bucketReadLock();
            try (InputStream inputStream2 = inputStream;){
                this.checkExistsBucket();
                this.checkNotExistObject();
                virtualFileSystemOperation = this.createObject();
                this.save(inputStream, string, string2, optional);
                bl = virtualFileSystemOperation.commit();
            }
            catch (InternalCriticalException internalCriticalException) {
                try {
                    bl2 = true;
                    throw internalCriticalException;
                    catch (Exception exception) {
                        bl2 = true;
                        throw new InternalCriticalException(exception, this.info(string));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (bl) throw throwable;
                        try {
                            this.rollback(virtualFileSystemOperation);
                            throw throwable;
                        }
                        catch (InternalCriticalException internalCriticalException2) {
                            if (!bl2) {
                                throw internalCriticalException2;
                            }
                            logger.error((Throwable)internalCriticalException2, new String[]{this.info(string), "---- not thrown ----"});
                            throw throwable;
                        }
                        catch (Exception exception) {
                            if (!bl2) {
                                throw new InternalCriticalException(exception, this.info(string));
                            }
                            logger.error((Throwable)exception, new String[]{this.info(string), "---- not thrown ----"});
                            throw throwable;
                        }
                    }
                    finally {
                        this.bucketReadUnLock();
                    }
                }
            }
            try {
                if (bl) return;
                try {
                    this.rollback(virtualFileSystemOperation);
                    return;
                }
                catch (InternalCriticalException internalCriticalException) {
                    if (!bl2) {
                        throw internalCriticalException;
                    }
                    logger.error((Throwable)internalCriticalException, new String[]{this.info(string), "---- not thrown ----"});
                    return;
                }
                catch (Exception exception) {
                    if (!bl2) {
                        throw new InternalCriticalException(exception, this.info(string));
                    }
                    logger.error((Throwable)exception, new String[]{this.info(string), "---- not thrown ----"});
                    return;
                }
            }
            finally {
                this.bucketReadUnLock();
            }
        }
        finally {
            this.objectWriteUnLock();
        }
    }

    private VirtualFileSystemOperation createObject() {
        return this.createObject(this.getBucket(), this.getObjectName());
    }

    private void save(InputStream inputStream, String string, String string2, Optional<List<String>> optional) {
        long l = this.saveData(this.getBucket(), this.getObjectName(), inputStream, string);
        this.saveMetadata(this.getBucket(), this.getObjectName(), string, l, string2, 0, optional);
    }
}

