/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid0.RAIDZeroTransactionObjectHandler;
import java.io.File;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;

@ThreadSafe
public class RAIDZeroDeleteObjectHandler
extends RAIDZeroTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDZeroDeleteObjectHandler.class.getName());

    protected RAIDZeroDeleteObjectHandler(RAIDZeroDriver rAIDZeroDriver, ServerBucket serverBucket, String string) {
        super(rAIDZeroDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete() {
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        this.objectWriteLock();
        try {
            this.bucketReadLock();
            try {
                this.checkExistsBucket();
                this.checkExistObject();
                n = this.getMetadata().getVersion();
                FileUtils.copyDirectory((File)this.getObjectPath().metadataDirPath().toFile(), (File)this.getObjectPath().metadataBackupDirPath().toFile());
                virtualFileSystemOperation = this.deleteObjectOperation(this.getMetadata().getVersion());
                FileUtils.deleteQuietly((File)this.getObjectPath().metadataDirPath().toFile());
                bl = virtualFileSystemOperation.commit();
            }
            catch (OdilonObjectNotFoundException odilonObjectNotFoundException) {
                try {
                    bl2 = true;
                    throw odilonObjectNotFoundException;
                    catch (InternalCriticalException internalCriticalException) {
                        bl2 = true;
                        throw internalCriticalException;
                    }
                    catch (Exception exception) {
                        bl2 = true;
                        throw new InternalCriticalException(exception, this.info());
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (bl) {
                            this.remove(n);
                            throw throwable;
                        }
                        try {
                            this.rollback(virtualFileSystemOperation);
                            throw throwable;
                        }
                        catch (Exception exception) {
                            if (!bl2) {
                                throw exception;
                            }
                            logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                            throw throwable;
                        }
                    }
                    finally {
                        this.bucketReadUnLock();
                    }
                }
            }
            try {
                if (bl) {
                    this.remove(n);
                    return;
                }
                try {
                    this.rollback(virtualFileSystemOperation);
                    return;
                }
                catch (Exception exception) {
                    if (!bl2) {
                        throw exception;
                    }
                    logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                    return;
                }
            }
            finally {
                this.bucketReadUnLock();
            }
        }
        finally {
            this.objectWriteUnLock();
        }
    }

    private void remove(int n) {
        try {
            for (int i = 0; i <= n; ++i) {
                FileUtils.deleteQuietly((File)this.getObjectPath().dataFileVersionPath(i).toFile());
            }
            FileUtils.deleteQuietly((File)this.getObjectPath().dataFilePath().toFile());
            FileUtils.deleteQuietly((File)this.getObjectPath().metadataWorkFilePath().toFile());
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
        }
    }

    private VirtualFileSystemOperation deleteObjectOperation(int n) {
        return this.deleteObject(this.getBucket(), this.getObjectName(), n);
    }
}

