/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.OdilonServerInfo;
import io.odilon.model.RedundancyLevel;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.scheduler.AbstractServiceRequest;
import io.odilon.scheduler.DeleteBucketObjectPreviousVersionServiceRequest;
import io.odilon.scheduler.ServiceRequest;
import io.odilon.util.Check;
import io.odilon.virtualFileSystem.BaseIODriver;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.OdilonBucket;
import io.odilon.virtualFileSystem.OdilonVirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.BucketIterator;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.DriveBucket;
import io.odilon.virtualFileSystem.model.JournalService;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemObject;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import io.odilon.virtualFileSystem.raid0.RAIDZeroBucketIterator;
import io.odilon.virtualFileSystem.raid0.RAIDZeroCreateObjectHandler;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDeleteObjectAllPreviousVersionsHandler;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDeleteObjectHandler;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriveSetupSync;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid0.RAIDZeroRestoreObjectPreviousVersionHandler;
import io.odilon.virtualFileSystem.raid0.RAIDZeroRollbackCreateHandler;
import io.odilon.virtualFileSystem.raid0.RAIDZeroRollbackDeleteHandler;
import io.odilon.virtualFileSystem.raid0.RAIDZeroRollbackRestorePreviousVersionHandler;
import io.odilon.virtualFileSystem.raid0.RAIDZeroRollbackUpdateHandler;
import io.odilon.virtualFileSystem.raid0.RAIDZeroUpdateObjectHandler;
import io.odilon.virtualFileSystem.raid0.RAIDZeroUpdateObjectMetadataHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@ThreadSafe
public class RAIDZeroDriver
extends BaseIODriver
implements ApplicationContextAware {
    private static Logger logger = Logger.getLogger((String)RAIDZeroDriver.class.getName());
    private static Logger std_logger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private ApplicationContext applicationContext;

    public RAIDZeroDriver(VirtualFileSystemService virtualFileSystemService, LockService lockService) {
        super(virtualFileSystemService, lockService);
    }

    public boolean hasVersions(ServerBucket serverBucket, String string) {
        return !this.getObjectMetadataVersionAll(serverBucket, string).isEmpty();
    }

    public void deleteObjectAllPreviousVersions(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null | b:" + serverBucket.getName()));
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        RAIDZeroDeleteObjectAllPreviousVersionsHandler rAIDZeroDeleteObjectAllPreviousVersionsHandler = new RAIDZeroDeleteObjectAllPreviousVersionsHandler(this, serverBucket, string);
        rAIDZeroDeleteObjectAllPreviousVersionsHandler.delete();
    }

    public ObjectMetadata restorePreviousVersion(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null | b:" + serverBucket.getName()));
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        RAIDZeroRestoreObjectPreviousVersionHandler rAIDZeroRestoreObjectPreviousVersionHandler = new RAIDZeroRestoreObjectPreviousVersionHandler(this, serverBucket, string);
        return rAIDZeroRestoreObjectPreviousVersionHandler.restorePreviousVersion();
    }

    public void deleteBucketAllPreviousVersions(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)serverBucket, (String)("bucket does not exist ->" + this.objectInfo(serverBucket)));
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(DeleteBucketObjectPreviousVersionServiceRequest.class, new Object[]{serverBucket.getName(), serverBucket.getId()}));
    }

    public void putObject(ServerBucket serverBucket, String string, InputStream inputStream, String string2, String string3, Optional<List<String>> optional) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        Check.requireNonNullStringArgument((String)string, (String)("objectName can not be null " + this.objectInfo(serverBucket)));
        Check.requireNonNullStringArgument((String)string2, (String)("fileName is null " + this.objectInfo(serverBucket, string)));
        Check.requireNonNullArgument((Object)inputStream, (String)("InpuStream can not null " + this.objectInfo(serverBucket, string)));
        if (this.exists(serverBucket, string)) {
            RAIDZeroUpdateObjectHandler rAIDZeroUpdateObjectHandler = new RAIDZeroUpdateObjectHandler(this, serverBucket, string);
            rAIDZeroUpdateObjectHandler.update(inputStream, string2, string3, optional);
            this.getSystemMonitorService().getUpdateObjectCounter().inc();
        } else {
            RAIDZeroCreateObjectHandler rAIDZeroCreateObjectHandler = new RAIDZeroCreateObjectHandler(this, serverBucket, string);
            rAIDZeroCreateObjectHandler.create(inputStream, string2, string3, optional);
            this.getSystemMonitorService().getCreateObjectCounter().inc();
        }
    }

    public void putObjectMetadata(ObjectMetadata objectMetadata) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        ServerBucket serverBucket = this.getBucket(objectMetadata.getBucketName());
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        RAIDZeroUpdateObjectMetadataHandler rAIDZeroUpdateObjectMetadataHandler = new RAIDZeroUpdateObjectMetadataHandler(this, serverBucket, objectMetadata.getObjectName());
        rAIDZeroUpdateObjectMetadataHandler.updateObjectMetadata(objectMetadata);
    }

    public void delete(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        Check.requireNonNullArgument((Object)string, (String)("objectName is null or empty | b:" + serverBucket.getName()));
        RAIDZeroDeleteObjectHandler rAIDZeroDeleteObjectHandler = new RAIDZeroDeleteObjectHandler(this, serverBucket, string);
        rAIDZeroDeleteObjectHandler.delete();
    }

    public void wipeAllPreviousVersions() {
        this.getSchedulerService().enqueue((ServiceRequest)this.getVirtualFileSystemService().getApplicationContext().getBean(DeleteBucketObjectPreviousVersionServiceRequest.class));
    }

    public void postObjectDeleteTransaction(ObjectMetadata objectMetadata, int n) {
    }

    public void postObjectPreviousVersionDeleteAllTransaction(ObjectMetadata objectMetadata, int n) {
    }

    public boolean setUpDrives() {
        return ((RAIDZeroDriveSetupSync)this.getApplicationContext().getBean(RAIDZeroDriveSetupSync.class, new Object[]{this})).setup();
    }

    public boolean isEmpty(ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        this.bucketReadLock(serverBucket);
        try {
            this.checkExistBucket(serverBucket);
            for (Drive drive : this.getDrivesEnabled()) {
                if (drive.isEmpty(serverBucket)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            if (exception instanceof InternalCriticalException) {
                throw exception;
            }
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket));
        }
        finally {
            this.bucketReadUnLock(serverBucket);
        }
    }

    /*
     * Exception decompiling
     */
    public VirtualFileSystemObject getObject(ServerBucket var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null or empty " + this.objectInfo(serverBucket)));
        this.objectReadLock(serverBucket, string);
        try {
            boolean bl;
            this.bucketReadLock(serverBucket);
            try {
                this.checkExistBucket(serverBucket);
                bl = this.existsObjectMetadata(serverBucket, string);
            }
            catch (Throwable throwable) {
                this.bucketReadUnLock(serverBucket);
                throw throwable;
            }
            this.bucketReadUnLock(serverBucket);
            return bl;
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataList<Item<ObjectMetadata>> listObjects(ServerBucket serverBucket, Optional<Long> optional, Optional<Integer> optional2, Optional<String> optional3, Optional<String> optional4) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        BucketIterator bucketIterator = null;
        try {
            DataList dataList;
            ObjectMetadata objectMetadata;
            if (optional4.isPresent()) {
                bucketIterator = this.getBucketIteratorService().get(optional4.get());
            }
            if (bucketIterator == null) {
                bucketIterator = new RAIDZeroBucketIterator(this, serverBucket, optional, optional3);
                this.getBucketIteratorService().register(bucketIterator);
            }
            ArrayList<DataList> arrayList = new ArrayList<DataList>();
            int n = optional2.orElseGet(() -> 60);
            int n2 = 0;
            while (bucketIterator.hasNext() && n2++ < n) {
                try {
                    objectMetadata = this.getOM(serverBucket, bucketIterator.next().toFile().getName(), Optional.empty(), false);
                    dataList = new Item((Serializable)objectMetadata);
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    dataList = new Item(exception);
                }
                arrayList.add(dataList);
            }
            dataList = new DataList(arrayList);
            if (!bucketIterator.hasNext()) {
                dataList.setEOD(true);
            }
            dataList.setOffset(bucketIterator.getOffset().longValue());
            dataList.setPageSize((long)n);
            dataList.setAgentId(bucketIterator.getAgentId());
            objectMetadata = dataList;
            return objectMetadata;
        }
        finally {
            if (bucketIterator != null && !bucketIterator.hasNext()) {
                this.getBucketIteratorService().remove(bucketIterator.getAgentId());
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<ObjectMetadata> getObjectMetadataVersionAll(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null or empty " + this.objectInfo(serverBucket)));
        ArrayList<ObjectMetadata> arrayList = null;
        Drive drive = null;
        this.objectReadLock(serverBucket, string);
        try {
            ArrayList<ObjectMetadata> arrayList2;
            this.bucketReadLock(serverBucket);
            try {
                arrayList = new ArrayList<ObjectMetadata>();
                this.checkExistBucket(serverBucket);
                drive = this.getReadDrive(serverBucket, string);
                ObjectMetadata objectMetadata = this.getDriverObjectMetadataInternal(serverBucket, string, true);
                if (objectMetadata == null || !objectMetadata.isAccesible()) {
                    throw new OdilonObjectNotFoundException(ObjectMetadata.class.getSimpleName());
                }
                if (objectMetadata.getVersion() == 0) {
                    ArrayList<ObjectMetadata> arrayList3 = arrayList;
                    return arrayList3;
                }
                for (int i = 0; i < objectMetadata.getVersion(); ++i) {
                    ObjectMetadata objectMetadata2 = drive.getObjectMetadataVersion(serverBucket, string, i);
                    if (objectMetadata2 == null) continue;
                    objectMetadata2.setBucketName(serverBucket.getName());
                    arrayList.add(objectMetadata2);
                }
                arrayList2 = arrayList;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (OdilonObjectNotFoundException odilonObjectNotFoundException) {
                odilonObjectNotFoundException.setErrorMessage((String)(odilonObjectNotFoundException.getMessage() != null ? odilonObjectNotFoundException.getMessage() + " | " : "") + this.objectInfo(serverBucket, string));
                throw odilonObjectNotFoundException;
            }
            catch (Exception exception) {
                if (exception instanceof InternalCriticalException) {
                    throw exception;
                }
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            return arrayList2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }

    public ObjectMetadata getObjectMetadata(ServerBucket serverBucket, String string) {
        return this.getOM(serverBucket, string, Optional.empty(), true);
    }

    public ObjectMetadata getObjectMetadataVersion(ServerBucket serverBucket, String string, int n) {
        return this.getOM(serverBucket, string, Optional.of(n), true);
    }

    /*
     * Loose catch block
     */
    public InputStream getObjectVersionInputStream(ServerBucket serverBucket, String string, int n) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireTrue((boolean)serverBucket.isAccesible(), (String)("bucket is not Accesible " + this.objectInfo(serverBucket)));
        Check.requireNonNullStringArgument((String)string, (String)("objectName is null or empty " + this.objectInfo(serverBucket)));
        this.objectReadLock(serverBucket, string);
        try {
            this.bucketReadLock(serverBucket);
            try {
                this.checkExistBucket(serverBucket);
                Drive drive = this.getReadDrive(serverBucket, string);
                ObjectMetadata objectMetadata = this.getObjectMetadataVersion(serverBucket, string, n);
                if (objectMetadata == null || !objectMetadata.isAccesible()) {
                    throw new OdilonObjectNotFoundException(ObjectMetadata.class.getSimpleName());
                }
                ObjectPath objectPath = new ObjectPath(drive, serverBucket, string);
                InputStream inputStream = Files.newInputStream(objectPath.dataFileVersionPath(n), new OpenOption[0]);
                if (objectMetadata.isEncrypt()) {
                    InputStream inputStream2 = this.getEncryptionService().decryptStream(inputStream);
                    return inputStream2;
                }
                InputStream inputStream3 = inputStream;
                return inputStream3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (OdilonObjectNotFoundException odilonObjectNotFoundException) {
                throw odilonObjectNotFoundException;
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.objectReadUnLock(serverBucket, string);
        }
    }

    /*
     * Exception decompiling
     */
    public InputStream getInputStream(ServerBucket var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<VirtualFileSystemOperation> getJournalPending(JournalService journalService) {
        ArrayList<VirtualFileSystemOperation> arrayList = new ArrayList<VirtualFileSystemOperation>();
        Drive drive = (Drive)this.getDrivesEnabled().get(0);
        File file = new File(drive.getJournalDirPath());
        if (!file.exists()) {
            return arrayList;
        }
        if (!file.isDirectory()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            return arrayList;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) continue;
            Path path = Paths.get(file2.getAbsolutePath(), new String[0]);
            try {
                String string = Files.readString(path);
                OdilonVirtualFileSystemOperation odilonVirtualFileSystemOperation = (OdilonVirtualFileSystemOperation)this.getObjectMapper().readValue(string, OdilonVirtualFileSystemOperation.class);
                odilonVirtualFileSystemOperation.setJournalService(this.getJournalService());
                arrayList.add((VirtualFileSystemOperation)odilonVirtualFileSystemOperation);
            }
            catch (IOException iOException) {
                logger.debug((Throwable)iOException, new String[]{this.fileInfo(file2)});
                try {
                    Files.delete(file2.toPath());
                }
                catch (IOException iOException2) {
                    logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                }
            }
        }
        std_logger.info("Rollback -> " + String.valueOf(arrayList.size()) + " transactions");
        return arrayList;
    }

    public List<ServiceRequest> getSchedulerPendingRequests(String string) {
        ArrayList<ServiceRequest> arrayList = new ArrayList<ServiceRequest>();
        Drive drive = (Drive)this.getDrivesEnabled().get(0);
        for (File file : drive.getSchedulerRequests(string)) {
            try {
                arrayList.add((ServiceRequest)this.getObjectMapper().readValue(file, AbstractServiceRequest.class));
            }
            catch (IOException iOException) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException iOException2) {
                    logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
                }
            }
        }
        return arrayList;
    }

    public void saveJournal(VirtualFileSystemOperation virtualFileSystemOperation) {
        ((Drive)this.getDrivesEnabled().get(0)).saveJournal(virtualFileSystemOperation);
    }

    public void removeJournal(String string) {
        ((Drive)this.getDrivesEnabled().get(0)).removeJournal(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void rollback(VirtualFileSystemOperation virtualFileSystemOperation, Object object, boolean bl) {
        block35: {
            block32: {
                switch (1.$SwitchMap$io$odilon$virtualFileSystem$model$OperationCode[virtualFileSystemOperation.getOperationCode().ordinal()]) {
                    case 1: {
                        RAIDZeroRollbackCreateHandler rAIDZeroRollbackCreateHandler = new RAIDZeroRollbackCreateHandler(this, virtualFileSystemOperation, bl);
                        rAIDZeroRollbackCreateHandler.rollback();
                        return;
                    }
                    case 2: {
                        RAIDZeroRollbackUpdateHandler rAIDZeroRollbackUpdateHandler = new RAIDZeroRollbackUpdateHandler(this, virtualFileSystemOperation, bl);
                        rAIDZeroRollbackUpdateHandler.rollback();
                        return;
                    }
                    case 3: {
                        RAIDZeroRollbackUpdateHandler rAIDZeroRollbackUpdateHandler = new RAIDZeroRollbackUpdateHandler(this, virtualFileSystemOperation, bl);
                        rAIDZeroRollbackUpdateHandler.rollback();
                        return;
                    }
                    case 4: {
                        RAIDZeroRollbackRestorePreviousVersionHandler rAIDZeroRollbackRestorePreviousVersionHandler = new RAIDZeroRollbackRestorePreviousVersionHandler(this, virtualFileSystemOperation, bl);
                        rAIDZeroRollbackRestorePreviousVersionHandler.rollback();
                        return;
                    }
                    case 5: {
                        RAIDZeroRollbackDeleteHandler rAIDZeroRollbackDeleteHandler = new RAIDZeroRollbackDeleteHandler(this, virtualFileSystemOperation, bl);
                        rAIDZeroRollbackDeleteHandler.rollback();
                        return;
                    }
                    case 6: {
                        RAIDZeroRollbackDeleteHandler rAIDZeroRollbackDeleteHandler = new RAIDZeroRollbackDeleteHandler(this, virtualFileSystemOperation, bl);
                        rAIDZeroRollbackDeleteHandler.rollback();
                        return;
                    }
                }
                boolean bl2 = false;
                try {
                    if (virtualFileSystemOperation.getOperationCode() == OperationCode.CREATE_BUCKET) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    } else if (virtualFileSystemOperation.getOperationCode() == OperationCode.DELETE_BUCKET) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    } else if (virtualFileSystemOperation.getOperationCode() == OperationCode.UPDATE_BUCKET) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    }
                    if (virtualFileSystemOperation.getOperationCode() == OperationCode.CREATE_SERVER_MASTERKEY) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    } else if (virtualFileSystemOperation.getOperationCode() == OperationCode.CREATE_SERVER_METADATA) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    } else if (virtualFileSystemOperation.getOperationCode() == OperationCode.UPDATE_SERVER_METADATA) {
                        bl2 = this.generalRollbackJournal(virtualFileSystemOperation);
                    }
                    if (!bl2 && !bl) break block32;
                }
                catch (InternalCriticalException internalCriticalException) {
                    block33: {
                        if (!bl) {
                            throw internalCriticalException;
                        }
                        logger.error(new String[]{this.opInfo(virtualFileSystemOperation), "---- not thrown ----"});
                        if (!bl2 && !bl) break block33;
                        virtualFileSystemOperation.cancel();
                    }
                    if (this.getServerSettings().isRecovery()) {
                        logger.error(new String[]{"---------------------------------------------------------------"});
                        logger.error(new String[]{"Cancelling failed operation -> " + this.opInfo(virtualFileSystemOperation)});
                        logger.error(new String[]{"---------------------------------------------------------------"});
                        virtualFileSystemOperation.cancel();
                    }
                }
                catch (Exception exception) {
                    block34: {
                        if (!bl) {
                            throw new InternalCriticalException(exception, this.opInfo(virtualFileSystemOperation));
                        }
                        logger.error(new String[]{this.opInfo(virtualFileSystemOperation), "---- not thrown ----"});
                        if (!bl2 && !bl) break block34;
                        {
                            catch (Throwable throwable) {
                                if (bl2 || bl) {
                                    virtualFileSystemOperation.cancel();
                                } else if (this.getServerSettings().isRecovery()) {
                                    logger.error(new String[]{"---------------------------------------------------------------"});
                                    logger.error(new String[]{"Cancelling failed operation -> " + this.opInfo(virtualFileSystemOperation)});
                                    logger.error(new String[]{"---------------------------------------------------------------"});
                                    virtualFileSystemOperation.cancel();
                                }
                                throw throwable;
                            }
                        }
                        virtualFileSystemOperation.cancel();
                    }
                    if (this.getServerSettings().isRecovery()) {
                        logger.error(new String[]{"---------------------------------------------------------------"});
                        logger.error(new String[]{"Cancelling failed operation -> " + this.opInfo(virtualFileSystemOperation)});
                        logger.error(new String[]{"---------------------------------------------------------------"});
                        virtualFileSystemOperation.cancel();
                    }
                }
                virtualFileSystemOperation.cancel();
                break block35;
            }
            if (this.getServerSettings().isRecovery()) {
                logger.error(new String[]{"---------------------------------------------------------------"});
                logger.error(new String[]{"Cancelling failed operation -> " + this.opInfo(virtualFileSystemOperation)});
                logger.error(new String[]{"---------------------------------------------------------------"});
                virtualFileSystemOperation.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveServerMasterKey(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        Check.requireNonNullArgument((Object)byArray, (String)"key is null");
        Check.requireNonNullArgument((Object)byArray4, (String)"salt is null");
        boolean bl = false;
        boolean bl2 = false;
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        this.getLockService().getServerLock().writeLock().lock();
        try {
            Object object2222222;
            for (Object object2222222 : this.getDrivesAll()) {
            }
            virtualFileSystemOperation = this.getJournalService().saveServerKey();
            bl2 = true;
            Object object3 = null;
            object2222222 = new byte[byArray2.length + byArray3.length + byArray.length + byArray4.length];
            System.arraycopy(byArray2, 0, object2222222, 0, byArray2.length);
            System.arraycopy(byArray, 0, object2222222, byArray2.length, byArray.length);
            System.arraycopy(byArray3, 0, object2222222, byArray2.length + byArray.length, byArray3.length);
            System.arraycopy(byArray4, 0, object2222222, byArray2.length + byArray3.length + byArray.length, byArray4.length);
            byte[] byArray5 = this.getVirtualFileSystemService().getMasterKeyEncryptorService().encryptKey((byte[])object2222222, byArray3);
            for (Drive drive : this.getDrivesAll()) {
                try {
                    File file = drive.getSysFile("key.enc");
                    FileUtils.writeByteArrayToFile((File)file, (byte[])byArray5);
                }
                catch (Exception exception) {
                    object3 = new InternalCriticalException(exception, "Drive -> " + drive.getName());
                    break;
                }
            }
            if (object3 != null) {
                throw object3;
            }
            bl = virtualFileSystemOperation.commit();
        }
        catch (InternalCriticalException internalCriticalException) {
            try {
                throw internalCriticalException;
                catch (Exception exception) {
                    if (!logger.isDebugEnabled()) throw new InternalCriticalException(exception, "saveServerMasterKey");
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    throw new InternalCriticalException(exception, "saveServerMasterKey");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bl) throw throwable;
                    if (!bl2) {
                        virtualFileSystemOperation.cancel();
                        throw throwable;
                    }
                    this.rollback(virtualFileSystemOperation);
                    throw throwable;
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    throw throwable;
                }
                finally {
                    this.getLockService().getServerLock().writeLock().unlock();
                }
            }
        }
        try {
            if (bl) return;
            if (!bl2) {
                virtualFileSystemOperation.cancel();
                return;
            }
            this.rollback(virtualFileSystemOperation);
            return;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return;
        }
        finally {
            this.getLockService().getServerLock().writeLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean checkIntegrity(ServerBucket var1_1, String var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 32[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RedundancyLevel getRedundancyLevel() {
        return RedundancyLevel.RAID_0;
    }

    public void saveScheduler(ServiceRequest serviceRequest, String string) {
        ((Drive)this.getDrivesEnabled().get(0)).saveScheduler(serviceRequest, string);
    }

    public void removeScheduler(ServiceRequest serviceRequest, String string) {
        ((Drive)this.getDrivesEnabled().get(0)).removeScheduler(serviceRequest, string);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public OdilonServerInfo getServerInfo() {
        try {
            this.getLockService().getServerLock().readLock().lock();
            File file = ((Drive)this.getDrivesEnabled().get(0)).getSysFile("odilon.json");
            if (file == null || !file.exists()) {
                OdilonServerInfo odilonServerInfo = null;
                return odilonServerInfo;
            }
            OdilonServerInfo odilonServerInfo = (OdilonServerInfo)this.getObjectMapper().readValue(file, OdilonServerInfo.class);
            return odilonServerInfo;
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException, new String[]{"---- not thrown ----"});
            throw new InternalCriticalException((Exception)iOException);
        }
        finally {
            this.getLockService().getServerLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setServerInfo(OdilonServerInfo odilonServerInfo) {
        Check.requireNonNullArgument((Object)odilonServerInfo, (String)"serverInfo is null");
        if (this.getServerInfo() == null) {
            this.saveNewServerInfo(odilonServerInfo);
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        this.getLockService().getServerLock().writeLock().lock();
        try {
            virtualFileSystemOperation = this.getJournalService().updateServerMetadata();
            String string = this.getObjectMapper().writeValueAsString((Object)odilonServerInfo);
            for (Drive drive : this.getDrivesAll()) {
            }
            bl2 = true;
            for (Drive drive : this.getDrivesAll()) {
                try {
                    drive.putSysFile("odilon.json", string);
                }
                catch (Exception exception) {
                    bl = false;
                    throw new InternalCriticalException(exception, "Drive -> " + drive.getName());
                }
            }
            bl = virtualFileSystemOperation.commit();
        }
        catch (Exception exception) {
            try {
                logger.error((Throwable)exception, new String[]{odilonServerInfo.toString()});
                throw new InternalCriticalException(exception, odilonServerInfo.toString());
            }
            catch (Throwable throwable) {
                try {
                    if (!bl2) {
                        virtualFileSystemOperation.cancel();
                        throw throwable;
                    }
                    if (bl) throw throwable;
                    this.rollback(virtualFileSystemOperation);
                    throw throwable;
                }
                catch (Exception exception2) {
                    logger.error((Throwable)exception2, new String[]{"---- not thrown ----"});
                    throw throwable;
                }
                finally {
                    this.getLockService().getServerLock().writeLock().unlock();
                }
            }
        }
        try {
            if (!bl2) {
                virtualFileSystemOperation.cancel();
                return;
            }
            if (bl) return;
            this.rollback(virtualFileSystemOperation);
            return;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return;
        }
        finally {
            this.getLockService().getServerLock().writeLock().unlock();
        }
    }

    public void syncObject(ObjectMetadata objectMetadata) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        logger.error(new String[]{"not done", "---- not thrown ----"});
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected Drive getObjectMetadataReadDrive(ServerBucket serverBucket, String string) {
        return this.getReadDrive(serverBucket, string);
    }

    protected Drive getWriteDrive(ServerBucket serverBucket, String string) {
        return this.getDrive(serverBucket, string);
    }

    protected Map<String, ServerBucket> getBucketsMap() {
        Integer n;
        Object object;
        HashMap<String, ServerBucket> hashMap = new HashMap<String, ServerBucket>();
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
        int n2 = this.getDrivesEnabled().size();
        for (Object object2 : this.getDrivesEnabled()) {
            for (Object object3 : object2.getBuckets()) {
                if (!object3.getStatus().isAccesible()) continue;
                object = object3.getName();
                n = hashMap2.containsKey(object) ? Integer.valueOf((Integer)hashMap2.get(object) + 1) : Integer.valueOf(1);
                hashMap2.put(object, n);
            }
        }
        Drive drive = (Drive)this.getDrivesEnabled().get(0);
        for (DriveBucket driveBucket : drive.getBuckets()) {
            Object object3;
            object3 = driveBucket.getName();
            if (!hashMap2.containsKey(object3) || (Integer)(object = (Integer)hashMap2.get(object3)) != n2) continue;
            n = new OdilonBucket(driveBucket);
            hashMap.put(n.getName(), (ServerBucket)n);
        }
        return hashMap;
    }

    protected Drive getReadDrive(ServerBucket serverBucket, String string) {
        return this.getDrive(serverBucket, string);
    }

    protected Drive getReadDrive(ServerBucket serverBucket) {
        return this.getDrive(serverBucket, null);
    }

    protected Drive getDrive(ServerBucket serverBucket, String string) {
        return (Drive)this.getDrivesEnabled().get(Math.abs(string.hashCode() % this.getDrivesEnabled().size()));
    }

    protected String fileInfo(File file) {
        if (file == null) {
            return "f:null";
        }
        return "f:" + file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveNewServerInfo(OdilonServerInfo odilonServerInfo) {
        boolean bl = false;
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        this.getLockService().getServerLock().writeLock().lock();
        try {
            virtualFileSystemOperation = this.getJournalService().createServerMetadata();
            String string = this.getObjectMapper().writeValueAsString((Object)odilonServerInfo);
            for (Drive drive : this.getDrivesAll()) {
                try {
                    drive.putSysFile("odilon.json", string);
                }
                catch (Exception exception) {
                    bl = false;
                    throw new InternalCriticalException(exception, "Drive -> " + drive.getName());
                }
            }
            bl = virtualFileSystemOperation.commit();
        }
        catch (InternalCriticalException internalCriticalException) {
            try {
                throw internalCriticalException;
                catch (Exception exception) {
                    throw new InternalCriticalException(exception, odilonServerInfo.toString());
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bl) throw throwable;
                    this.rollback(virtualFileSystemOperation);
                    throw throwable;
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    throw throwable;
                }
                finally {
                    this.getLockService().getServerLock().writeLock().unlock();
                }
            }
        }
        try {
            if (bl) return;
            this.rollback(virtualFileSystemOperation);
            return;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return;
        }
        finally {
            this.getLockService().getServerLock().writeLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    private ObjectMetadata getOM(ServerBucket var1_1, String var2_2, Optional<Integer> var3_3, boolean var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkNotExistObject(ServerBucket serverBucket, String string) {
        if (this.existsObjectMetadata(serverBucket, string)) {
            throw new IllegalArgumentException("Object already exist -> " + this.objectInfo(serverBucket, string));
        }
    }

    protected void checkExistObject(ServerBucket serverBucket, String string) {
        if (!this.existsObjectMetadata(serverBucket, string)) {
            throw new OdilonObjectNotFoundException("Object does not exist -> " + this.objectInfo(serverBucket, string));
        }
    }

    private boolean existsObjectMetadata(ServerBucket serverBucket, String string) {
        if (this.getVirtualFileSystemService().getObjectMetadataCacheService().containsKey(serverBucket, string)) {
            return true;
        }
        return this.getDrive(serverBucket, string).existsObjectMetadata(serverBucket, string);
    }
}

