/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.encryption.EncryptedResult;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ObjectStatus;
import io.odilon.util.OdilonFileUtils;
import io.odilon.virtualFileSystem.BaseRAIDHandler;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.RAIDHandler;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;

@ThreadSafe
public abstract class RAIDZeroHandler
extends BaseRAIDHandler
implements RAIDHandler {
    private static Logger logger = Logger.getLogger((String)RAIDZeroHandler.class.getName());
    @JsonIgnore
    private final RAIDZeroDriver driver;

    protected Drive getObjectMetadataReadDrive(ServerBucket serverBucket, String string) {
        return this.getDriver().getReadDrive(serverBucket, string);
    }

    public RAIDZeroHandler(RAIDZeroDriver rAIDZeroDriver) {
        this.driver = rAIDZeroDriver;
    }

    public RAIDZeroDriver getDriver() {
        return this.driver;
    }

    public Drive getWriteDrive(ServerBucket serverBucket, String string) {
        return this.getDriver().getWriteDrive(serverBucket, string);
    }

    protected long saveData(ServerBucket serverBucket, String string, InputStream inputStream, String string2) {
        long l;
        block32: {
            byte[] byArray = new byte[8192];
            long l2 = 0L;
            if (this.isEncrypt()) {
                long l3;
                block30: {
                    EncryptedResult encryptedResult = this.getEncryptionService().encryptStream(inputStream);
                    InputStream inputStream2 = encryptedResult.getInputStream();
                    try {
                        ObjectPath objectPath = new ObjectPath(this.getWriteDrive(serverBucket, string), serverBucket, string);
                        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(objectPath.dataFilePath().toFile()), 8192);){
                            int n;
                            while ((n = inputStream2.read(byArray, 0, byArray.length)) >= 0) {
                                bufferedOutputStream.write(byArray, 0, n);
                            }
                        }
                        l2 = encryptedResult.getCountingStream().getCount();
                        logger.debug("b: " + serverBucket.getName() + " o: " + string + " f: " + string2 + " | bytes read: " + l2 + " | encrypted file -> " + objectPath.dataFilePath().toFile().length() + " bytes ");
                        l3 = l2;
                        if (inputStream2 == null) break block30;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream2 != null) {
                                try {
                                    inputStream2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string, string2));
                        }
                    }
                    inputStream2.close();
                }
                return l3;
            }
            InputStream inputStream3 = inputStream;
            try {
                ObjectPath objectPath = new ObjectPath(this.getWriteDrive(serverBucket, string), serverBucket, string);
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(objectPath.dataFilePath().toFile()), 8192);){
                    int n;
                    while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                        bufferedOutputStream.write(byArray, 0, n);
                        l2 += (long)n;
                    }
                }
                l = l2;
                if (inputStream3 == null) break block32;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream3 != null) {
                        try {
                            inputStream3.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string, string2));
                }
            }
            inputStream3.close();
        }
        return l;
    }

    protected void saveMetadata(ServerBucket serverBucket, String string, String string2, long l, String string3, int n, Optional<List<String>> optional) {
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        Drive drive = this.getWriteDrive(serverBucket, string);
        ObjectPath objectPath = new ObjectPath(drive, serverBucket, string);
        try {
            String string4 = OdilonFileUtils.calculateSHA256String((File)objectPath.dataFilePath().toFile());
            ObjectMetadata objectMetadata = new ObjectMetadata(serverBucket.getId(), string);
            objectMetadata.setFileName(string2);
            objectMetadata.setAppVersion("1.15");
            objectMetadata.setContentType(string3);
            objectMetadata.setEncrypt(this.isEncrypt());
            objectMetadata.setVault(this.isUseVaultNewFiles());
            objectMetadata.setCreationDate(offsetDateTime);
            objectMetadata.setLastModified(offsetDateTime);
            objectMetadata.setVersioncreationDate(offsetDateTime);
            objectMetadata.setVersion(n);
            objectMetadata.setSourceLength(l);
            objectMetadata.setLength(objectPath.dataFilePath().toFile().length());
            objectMetadata.setEtag(string4);
            objectMetadata.setIntegrityCheck(offsetDateTime);
            objectMetadata.setSha256(string4);
            objectMetadata.setStatus(ObjectStatus.ENABLED);
            objectMetadata.setDrive(drive.getName());
            if (optional.isPresent()) {
                objectMetadata.setCustomTags(optional.get());
            }
            objectMetadata.setRaid(String.valueOf(this.getRedundancyLevel().getCode()).trim());
            objectMetadata.setRaidDrives(this.getDriver().getTotalDisks());
            if (!objectPath.metadataDirPath().toFile().exists()) {
                FileUtils.forceMkdir((File)objectPath.metadataDirPath().toFile());
            }
            Files.writeString(objectPath.metadataFilePath(), (CharSequence)this.getObjectMapper().writeValueAsString((Object)objectMetadata), new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string, string2));
        }
    }

    protected void checkNotExistObject(ServerBucket serverBucket, String string) {
        if (this.existsObjectMetadata(serverBucket, string)) {
            throw new IllegalArgumentException("Object already exist -> " + this.objectInfo(serverBucket, string));
        }
    }

    protected void checkExistObject(ServerBucket serverBucket, String string) {
        if (!this.existsObjectMetadata(serverBucket, string)) {
            throw new OdilonObjectNotFoundException("Object does not exist -> " + this.objectInfo(serverBucket, string));
        }
    }

    protected boolean existsObjectMetadata(ServerBucket serverBucket, String string) {
        if (this.existsCacheObject(serverBucket, string)) {
            return true;
        }
        return this.getDriver().getWriteDrive(serverBucket, string).existsObjectMetadata(serverBucket, string);
    }
}

