/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid0.RAIDZeroRollbackObjectHandler;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class RAIDZeroRollbackCreateHandler
extends RAIDZeroRollbackObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDZeroRollbackCreateHandler.class.getName());

    public RAIDZeroRollbackCreateHandler(RAIDZeroDriver rAIDZeroDriver, VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        super(rAIDZeroDriver, virtualFileSystemOperation, bl);
    }

    protected void rollback() {
        boolean bl = false;
        try {
            FileUtils.deleteQuietly((File)this.getObjectPath().metadataDirPath().toFile());
            FileUtils.deleteQuietly((File)this.getObjectPath().dataFilePath().toFile());
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error((Throwable)internalCriticalException, new String[]{this.info(), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.info());
            }
            logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }
}

