/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.odilon.model.ObjectMetadata;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid0.RAIDZeroTransactionHandler;

public abstract class RAIDZeroTransactionObjectHandler
extends RAIDZeroTransactionHandler {
    @JsonProperty(value="bucket")
    private final ServerBucket bucket;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonIgnore
    private ObjectPath path = null;

    public RAIDZeroTransactionObjectHandler(RAIDZeroDriver rAIDZeroDriver, ServerBucket serverBucket, String string) {
        super(rAIDZeroDriver);
        this.bucket = serverBucket;
        this.objectName = string;
    }

    protected void bucketReadLock() {
        this.bucketReadLock(this.getBucket());
    }

    protected void objectWriteLock() {
        this.objectWriteLock(this.getBucket(), this.getObjectName());
    }

    protected String info() {
        return this.objectInfo(this.getBucket(), this.getObjectName());
    }

    protected String info(String string) {
        return this.objectInfo(this.getBucket(), this.getObjectName(), string);
    }

    protected ObjectMetadata getMetadata() {
        return this.getMetadata(this.getBucket(), this.getObjectName(), true);
    }

    protected void objectWriteUnLock() {
        this.objectWriteUnLock(this.getBucket(), this.getObjectName());
    }

    protected void bucketReadUnLock() {
        this.bucketReadUnLock(this.getBucket());
    }

    protected void checkNotExistObject() {
        this.checkNotExistObject(this.getBucket(), this.getObjectName());
    }

    protected void checkExistObject() {
        this.checkExistObject(this.getBucket(), this.getObjectName());
    }

    protected void checkExistsBucket() {
        this.checkExistsBucket(this.getBucket());
    }

    protected ServerBucket getBucket() {
        return this.bucket;
    }

    protected String getObjectName() {
        return this.objectName;
    }

    protected ObjectPath getObjectPath() {
        if (this.path == null) {
            this.path = new ObjectPath(this.getDriver().getDrive(this.getBucket(), this.getObjectName()), this.getBucket(), this.getObjectName());
        }
        return this.path;
    }
}

