/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid0;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid0.RAIDZeroDriver;
import io.odilon.virtualFileSystem.raid0.RAIDZeroTransactionObjectHandler;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.FileUtils;

public class RAIDZeroUpdateObjectMetadataHandler
extends RAIDZeroTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDZeroUpdateObjectMetadataHandler.class.getName());

    public RAIDZeroUpdateObjectMetadataHandler(RAIDZeroDriver rAIDZeroDriver, ServerBucket serverBucket, String string) {
        super(rAIDZeroDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateObjectMetadata(ObjectMetadata objectMetadata) {
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl = false;
        boolean bl2 = false;
        this.objectWriteLock();
        try {
            this.bucketReadLock();
            try {
                this.checkExistsBucket();
                this.checkExistObject();
                FileUtils.copyDirectory((File)this.getObjectPath().metadataDirPath().toFile(), (File)this.getObjectPath().metadataBackupDirPath().toFile());
                virtualFileSystemOperation = this.updateObjectMetadata(objectMetadata.getVersion());
                Files.writeString(this.getObjectPath().metadataFilePath(), (CharSequence)this.getObjectMapper().writeValueAsString((Object)objectMetadata), new OpenOption[0]);
                bl = virtualFileSystemOperation.commit();
            }
            catch (InternalCriticalException internalCriticalException) {
                try {
                    bl2 = true;
                    throw internalCriticalException;
                    catch (Exception exception) {
                        bl2 = true;
                        throw new InternalCriticalException(exception, this.info());
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (!bl) {
                            try {
                                this.rollback(virtualFileSystemOperation);
                                throw throwable;
                            }
                            catch (Exception exception) {
                                if (!bl2) {
                                    throw new InternalCriticalException(exception, this.info());
                                }
                                logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                                throw throwable;
                            }
                        }
                        try {
                            FileUtils.deleteQuietly((File)this.getObjectPath().metadataWorkFilePath().toFile());
                            throw throwable;
                        }
                        catch (Exception exception) {
                            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                            throw throwable;
                        }
                    }
                    finally {
                        this.bucketReadUnLock();
                    }
                }
            }
            try {
                if (!bl) {
                    try {
                        this.rollback(virtualFileSystemOperation);
                        return;
                    }
                    catch (Exception exception) {
                        if (!bl2) {
                            throw new InternalCriticalException(exception, this.info());
                        }
                        logger.error((Throwable)exception, new String[]{this.info(), "---- not thrown ----"});
                        return;
                    }
                }
                try {
                    FileUtils.deleteQuietly((File)this.getObjectPath().metadataWorkFilePath().toFile());
                    return;
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    return;
                }
            }
            finally {
                this.bucketReadUnLock();
            }
        }
        finally {
            this.objectWriteUnLock();
        }
    }

    private VirtualFileSystemOperation updateObjectMetadata(int n) {
        return this.getJournalService().updateObjectMetadata(this.getBucket(), this.getObjectName(), n);
    }
}

