/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import io.odilon.virtualFileSystem.raid1.RAIDOneRollbackHandler;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class RAIDOneRollbackCreateHandler
extends RAIDOneRollbackHandler {
    private static Logger logger = Logger.getLogger((String)RAIDOneRollbackCreateHandler.class.getName());

    public RAIDOneRollbackCreateHandler(RAIDOneDriver rAIDOneDriver, VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        super(rAIDOneDriver, virtualFileSystemOperation, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback() {
        boolean bl = false;
        try {
            ServerBucket serverBucket = this.getBucketCache().get(this.getOperation().getBucketId());
            for (Drive drive : this.getDriver().getDrivesAll()) {
                drive.deleteObjectMetadata(serverBucket, this.getOperation().getObjectName());
                ObjectPath objectPath = new ObjectPath(drive, serverBucket, this.getOperation().getObjectName());
                FileUtils.deleteQuietly((File)objectPath.dataFilePath().toFile());
            }
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error((Throwable)internalCriticalException, new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.opInfo(this.getOperation()));
            }
            logger.error((Throwable)exception, new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }
}

