/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import io.odilon.virtualFileSystem.raid1.RAIDOneRollbackHandler;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class RAIDOneRollbackDeleteHandler
extends RAIDOneRollbackHandler {
    private static Logger logger = Logger.getLogger((String)RAIDOneRollbackDeleteHandler.class.getName());

    public RAIDOneRollbackDeleteHandler(RAIDOneDriver rAIDOneDriver, VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        super(rAIDOneDriver, virtualFileSystemOperation, bl);
    }

    protected void rollback() {
        boolean bl = false;
        try {
            bl = this.restore();
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error(new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.opInfo(this.getOperation()));
            }
            logger.error(new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }

    private boolean restore() {
        ServerBucket serverBucket = this.getCacheBucket(this.getOperation().getBucketId());
        for (Drive drive : this.getDriver().getDrivesAll()) {
            String string = drive.getBucketWorkDirPath(serverBucket) + File.separator + this.getOperation().getObjectName();
            String string2 = drive.getObjectMetadataDirPath(serverBucket, this.getOperation().getObjectName());
            try {
                FileUtils.copyDirectory((File)new File(string), (File)new File(string2));
            }
            catch (IOException iOException) {
                throw new InternalCriticalException((Exception)iOException, this.objectInfo(serverBucket, this.getOperation().getObjectName()));
            }
        }
        return true;
    }
}

