/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.OperationCode;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.SimpleDrive;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import io.odilon.virtualFileSystem.raid1.RAIDOneRollbackHandler;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class RAIDOneRollbackUpdateHandler
extends RAIDOneRollbackHandler {
    private static Logger logger = Logger.getLogger((String)RAIDOneRollbackUpdateHandler.class.getName());

    public RAIDOneRollbackUpdateHandler(RAIDOneDriver rAIDOneDriver, VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        super(rAIDOneDriver, virtualFileSystemOperation, bl);
    }

    protected void rollback() {
        if (this.getOperation().getOperationCode() == OperationCode.UPDATE_OBJECT) {
            this.rollbackUpdate();
        } else if (this.getOperation().getOperationCode() == OperationCode.UPDATE_OBJECT_METADATA) {
            this.rollbackUpdateMetadata();
        } else if (this.getOperation().getOperationCode() == OperationCode.RESTORE_OBJECT_PREVIOUS_VERSION) {
            this.rollbackUpdate();
        }
    }

    private void rollbackUpdate() {
        boolean bl = false;
        try {
            this.restoreVersionObjectDataFile();
            this.restoreVersionObjectMetadata();
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            logger.error(new String[]{this.getDriver().opInfo(this.getOperation())});
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.opInfo(this.getOperation()));
            }
            logger.error((Throwable)exception, new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }

    private void rollbackUpdateMetadata() {
        boolean bl = false;
        try {
            this.restoreVersionObjectMetadata();
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.opInfo(this.getOperation()));
            }
            logger.error(new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }

    private boolean restoreVersionObjectDataFile() {
        ServerBucket serverBucket = this.getBucketCache().get(this.getOperation().getBucketId());
        try {
            boolean bl = true;
            for (Drive drive : this.getDriver().getDrivesAll()) {
                ObjectPath objectPath = new ObjectPath(drive, serverBucket, this.getOperation().getObjectName());
                File file = objectPath.dataFileVersionPath(this.getOperation().getVersion()).toFile();
                if (file.exists()) {
                    ((SimpleDrive)drive).putObjectDataFile(serverBucket.getId(), this.getOperation().getObjectName(), file);
                    FileUtils.deleteQuietly((File)file);
                    continue;
                }
                bl = false;
            }
            return bl;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket, this.getOperation().getObjectName()));
        }
    }

    private boolean restoreVersionObjectMetadata() {
        try {
            boolean bl = false;
            ServerBucket serverBucket = this.getBucketCache().get(this.getOperation().getBucketId());
            for (Drive drive : this.getDriver().getDrivesAll()) {
                File file = drive.getObjectMetadataVersionFile(serverBucket, this.getOperation().getObjectName(), this.getOperation().getVersion());
                if (!file.exists()) continue;
                drive.putObjectMetadataFile(serverBucket, this.getOperation().getObjectName(), file);
                FileUtils.deleteQuietly((File)file);
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.opInfo(this.getOperation()));
        }
    }
}

