/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid1;

import io.odilon.encryption.EncryptedResult;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ObjectStatus;
import io.odilon.util.Check;
import io.odilon.util.OdilonFileUtils;
import io.odilon.virtualFileSystem.ObjectPath;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.SimpleDrive;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid1.RAIDOneDriver;
import io.odilon.virtualFileSystem.raid1.RAIDOneTransactionHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;

@ThreadSafe
public class RAIDOneUpdateObjectHandler
extends RAIDOneTransactionHandler {
    private static Logger logger = Logger.getLogger((String)RAIDOneUpdateObjectHandler.class.getName());

    protected RAIDOneUpdateObjectHandler(RAIDOneDriver rAIDOneDriver) {
        super(rAIDOneDriver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(ServerBucket serverBucket, String string, InputStream inputStream, String string2, String string3, Optional<List<String>> optional) {
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        boolean bl2 = false;
        this.objectWriteLock(serverBucket, string);
        try {
            this.bucketReadLock(serverBucket);
            try (InputStream inputStream2 = inputStream;){
                this.checkExistsBucket(serverBucket);
                this.checkExistObject(serverBucket, string);
                ObjectMetadata objectMetadata = this.getMetadata(serverBucket, string, true);
                n = objectMetadata.getVersion();
                n2 = objectMetadata.getVersion() + 1;
                this.saveVersionObjectDataFile(serverBucket, string, objectMetadata.getVersion());
                this.saveVersionObjectMetadata(serverBucket, string, objectMetadata.getVersion());
                virtualFileSystemOperation = this.updateObject(serverBucket, string, n);
                this.saveObjectDataFile(serverBucket, string, inputStream, string2, n2);
                this.saveObjectMetadata(serverBucket, string, string2, string3, n2, optional);
                bl = virtualFileSystemOperation.commit();
            }
            catch (InternalCriticalException internalCriticalException) {
                try {
                    bl2 = true;
                    throw internalCriticalException;
                    catch (Exception exception) {
                        bl2 = true;
                        throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string, string2));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (!bl) {
                            try {
                                this.rollback(virtualFileSystemOperation);
                                throw throwable;
                            }
                            catch (Exception exception) {
                                if (!bl2) {
                                    throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string, string2));
                                }
                                logger.error((Throwable)exception, new String[]{this.objectInfo(serverBucket, string, string2), "---- not thrown ----"});
                                throw throwable;
                            }
                        }
                        this.cleanUpUpdate(virtualFileSystemOperation, serverBucket, string, n, n2);
                        throw throwable;
                    }
                    finally {
                        this.bucketReadUnLock(serverBucket);
                    }
                }
            }
            try {
                if (!bl) {
                    try {
                        this.rollback(virtualFileSystemOperation);
                        return;
                    }
                    catch (Exception exception) {
                        if (!bl2) {
                            throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string, string2));
                        }
                        logger.error((Throwable)exception, new String[]{this.objectInfo(serverBucket, string, string2), "---- not thrown ----"});
                        return;
                    }
                }
                this.cleanUpUpdate(virtualFileSystemOperation, serverBucket, string, n, n2);
                return;
            }
            finally {
                this.bucketReadUnLock(serverBucket);
            }
        }
        finally {
            this.objectWriteUnLock(serverBucket, string);
        }
    }

    /*
     * Exception decompiling
     */
    protected ObjectMetadata restorePreviousVersion(ServerBucket var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateObjectMetadata(ObjectMetadata objectMetadata) {
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl = false;
        boolean bl2 = false;
        ServerBucket serverBucket = null;
        this.getLockService().getObjectLock(objectMetadata.getBucketId(), objectMetadata.getObjectName()).writeLock().lock();
        try {
            this.getLockService().getBucketLock(objectMetadata.getBucketId()).readLock().lock();
            try {
                this.checkExistsBucket(objectMetadata.getBucketId());
                serverBucket = this.getBucketCache().get(objectMetadata.getBucketId());
                this.checkExistObject(serverBucket, objectMetadata.getObjectName());
                this.backupMetadata(objectMetadata, serverBucket);
                virtualFileSystemOperation = this.getJournalService().updateObjectMetadata(this.getBucketCache().get(objectMetadata.getBucketId()), objectMetadata.getObjectName(), objectMetadata.getVersion());
                this.saveObjectMetadata(objectMetadata);
                bl = virtualFileSystemOperation.commit();
            }
            catch (InternalCriticalException internalCriticalException) {
                try {
                    bl2 = true;
                    throw internalCriticalException;
                    catch (Exception exception) {
                        bl2 = true;
                        throw new InternalCriticalException(exception);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (!bl) {
                            try {
                                this.rollback(virtualFileSystemOperation);
                            }
                            catch (Exception exception) {
                                if (!bl2) {
                                    throw new InternalCriticalException(exception, this.getDriver().objectInfo(objectMetadata.bucketId, objectMetadata.objectName));
                                }
                                logger.error((Throwable)exception, new String[]{this.objectInfo(objectMetadata), "---- not thrown ----"});
                            }
                        } else {
                            this.cleanUpBackupMetadataDir(serverBucket, objectMetadata.getObjectName());
                        }
                        this.getLockService().getBucketLock(serverBucket).readLock().unlock();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        this.getLockService().getBucketLock(serverBucket).readLock().unlock();
                        throw throwable2;
                    }
                }
            }
            try {
                if (!bl) {
                    try {
                        this.rollback(virtualFileSystemOperation);
                        return;
                    }
                    catch (Exception exception) {
                        if (!bl2) {
                            throw new InternalCriticalException(exception, this.getDriver().objectInfo(objectMetadata.bucketId, objectMetadata.objectName));
                        }
                        logger.error((Throwable)exception, new String[]{this.objectInfo(objectMetadata), "---- not thrown ----"});
                        return;
                    }
                }
                this.cleanUpBackupMetadataDir(serverBucket, objectMetadata.getObjectName());
                return;
            }
            finally {
                this.getLockService().getBucketLock(serverBucket).readLock().unlock();
            }
        }
        finally {
            this.objectWriteUnLock(objectMetadata.getBucketId(), objectMetadata.getObjectName());
        }
    }

    protected void onAfterCommit(ServerBucket serverBucket, String string, int n, int n2) {
    }

    protected Drive getObjectMetadataReadDrive(ServerBucket serverBucket, String string) {
        return this.getDriver().getReadDrive(serverBucket, string);
    }

    protected boolean existsObjectMetadata(ServerBucket serverBucket, String string) {
        if (this.existsCacheObject(serverBucket, string)) {
            return true;
        }
        return this.getDriver().getReadDrive(serverBucket, string).existsObjectMetadata(serverBucket, string);
    }

    private void saveVersionObjectMetadata(ServerBucket serverBucket, String string, int n) {
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                drive.putObjectMetadataVersionFile(serverBucket, string, n, drive.getObjectMetadataFile(serverBucket, string));
            }
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.getDriver().objectInfo(serverBucket, string));
        }
    }

    private void saveVersionObjectDataFile(ServerBucket serverBucket, String string, int n) {
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                ObjectPath objectPath = new ObjectPath(drive, serverBucket, string);
                File file = objectPath.dataFilePath().toFile();
                ((SimpleDrive)drive).putObjectDataVersionFile(serverBucket.getId(), string, n, file);
            }
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.getDriver().objectInfo(serverBucket, string));
        }
    }

    /*
     * Loose catch block
     */
    private long saveObjectDataFile(ServerBucket serverBucket, String string, InputStream inputStream, String string2, int n) {
        long l;
        Serializable serializable;
        InputStream inputStream2;
        boolean bl;
        BufferedOutputStream[] bufferedOutputStreamArray;
        int n2;
        block61: {
            Object object;
            Object object22222;
            n2 = this.getDriver().getDrivesAll().size();
            bufferedOutputStreamArray = new BufferedOutputStream[n2];
            bl = false;
            if (this.isEncrypt()) {
                long l2;
                Object object3;
                InputStream inputStream3;
                block60: {
                    int n3;
                    block59: {
                        long l3;
                        Object object4;
                        Object object52222;
                        EncryptedResult encryptedResult = this.getEncryptionService().encryptStream(inputStream);
                        inputStream3 = encryptedResult.getInputStream();
                        int n4 = 0;
                        for (Object object52222 : this.getDriver().getDrivesAll()) {
                            ObjectPath objectPath = new ObjectPath(object52222, serverBucket.getId(), string);
                            object4 = objectPath.dataFilePath().toString();
                            bufferedOutputStreamArray[n4++] = new BufferedOutputStream(new FileOutputStream((String)object4), 8192);
                        }
                        int n5 = 0;
                        object52222 = new byte[8192];
                        if (this.getDriver().getDrivesAll().size() < 2) {
                            while ((n5 = inputStream3.read((byte[])object52222, 0, ((Drive)object52222).length)) >= 0) {
                                for (int i = 0; i < n2; ++i) {
                                    bufferedOutputStreamArray[i].write((byte[])object52222, 0, n5);
                                }
                            }
                        } else {
                            int n6 = this.getDriver().getDrivesAll().size();
                            object4 = this.getVirtualFileSystemService().getExecutorService();
                            while ((n5 = inputStream3.read((byte[])object52222, 0, ((Drive)object52222).length)) >= 0) {
                                ArrayList<Callable<Boolean>> arrayList = new ArrayList<Callable<Boolean>>(n6);
                                int n7 = 0;
                                while (n7 < n2) {
                                    int n8 = n7++;
                                    n3 = n5;
                                    arrayList.add(() -> RAIDOneUpdateObjectHandler.lambda$saveObjectDataFile$0(bufferedOutputStreamArray, n8, (byte[])object52222, n3));
                                }
                                try {
                                    List list = object4.invokeAll(arrayList, 5L, TimeUnit.MINUTES);
                                    object3 = list.iterator();
                                    while (object3.hasNext()) {
                                        if (((Boolean)object3.next().get()).booleanValue()) continue;
                                        throw new InternalCriticalException(this.getDriver().objectInfo(serverBucket, string, string2));
                                    }
                                }
                                catch (InterruptedException | ExecutionException exception) {
                                    throw new InternalCriticalException(exception);
                                }
                            }
                        }
                        l2 = l3 = encryptedResult.getCountingStream().getCount();
                        if (inputStream3 == null) break block59;
                        inputStream3.close();
                    }
                    object3 = null;
                    if (bufferedOutputStreamArray == null) break block60;
                    try {
                        for (n3 = 0; n3 < n2; ++n3) {
                            if (bufferedOutputStreamArray[n3] == null) continue;
                            bufferedOutputStreamArray[n3].close();
                        }
                    }
                    catch (IOException iOException) {
                        logger.error((Throwable)iOException, new String[]{this.getDriver().objectInfo(serverBucket, string, string2) + (bl ? "---- not thrown ----" : "")});
                        object3 = iOException;
                    }
                }
                if (!bl && object3 != null) {
                    throw new InternalCriticalException(object3);
                }
                return l2;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                if (inputStream3 != null) {
                                    try {
                                        inputStream3.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception exception) {
                                bl = true;
                                throw new InternalCriticalException(exception, this.getDriver().objectInfo(serverBucket, string, string2));
                            }
                        }
                        catch (Throwable throwable3) {
                            IOException iOException = null;
                            if (bufferedOutputStreamArray != null) {
                                try {
                                    for (int i = 0; i < n2; ++i) {
                                        if (bufferedOutputStreamArray[i] == null) continue;
                                        bufferedOutputStreamArray[i].close();
                                    }
                                }
                                catch (IOException iOException2) {
                                    logger.error((Throwable)iOException2, new String[]{this.getDriver().objectInfo(serverBucket, string, string2) + (bl ? "---- not thrown ----" : "")});
                                    iOException = iOException2;
                                }
                            }
                            if (!bl && iOException != null) {
                                throw new InternalCriticalException(iOException);
                            }
                            throw throwable3;
                        }
                    }
                }
            }
            inputStream2 = null;
            inputStream2 = inputStream;
            long l4 = 0L;
            int n9 = 0;
            for (Object object22222 : this.getDriver().getDrivesAll()) {
                ObjectPath objectPath = new ObjectPath(object22222, serverBucket.getId(), string);
                object = objectPath.dataFilePath().toString();
                bufferedOutputStreamArray[n9++] = new BufferedOutputStream(new FileOutputStream((String)object), 8192);
            }
            int n10 = 0;
            object22222 = new byte[8192];
            if (this.getDriver().getDrivesAll().size() < 2) {
                while ((n10 = inputStream2.read((byte[])object22222, 0, ((Drive)object22222).length)) >= 0) {
                    for (int i = 0; i < n2; ++i) {
                        bufferedOutputStreamArray[i].write((byte[])object22222, 0, n10);
                        l4 += (long)n10;
                    }
                }
            } else {
                int n11 = this.getDriver().getDrivesAll().size();
                object = this.getVirtualFileSystemService().getExecutorService();
                while ((n10 = inputStream2.read((byte[])object22222, 0, ((Drive)object22222).length)) >= 0) {
                    l4 += (long)n10;
                    serializable = new ArrayList(n11);
                    int n12 = 0;
                    while (n12 < n2) {
                        int n13 = n12++;
                        int n14 = n10;
                        serializable.add(() -> RAIDOneUpdateObjectHandler.lambda$saveObjectDataFile$0(bufferedOutputStreamArray, n13, (byte[])object22222, n14));
                    }
                    try {
                        List list = object.invokeAll(serializable, 5L, TimeUnit.MINUTES);
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            if (((Boolean)iterator.next().get()).booleanValue()) continue;
                            throw new InternalCriticalException(this.getDriver().objectInfo(serverBucket, string, string2));
                        }
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        throw new InternalCriticalException(exception);
                    }
                }
            }
            l = l4;
            serializable = null;
            if (bufferedOutputStreamArray == null) break block61;
            try {
                for (int i = 0; i < n2; ++i) {
                    if (bufferedOutputStreamArray[i] == null) continue;
                    bufferedOutputStreamArray[i].close();
                }
            }
            catch (IOException iOException) {
                logger.error((Throwable)iOException, new String[]{this.getDriver().objectInfo(serverBucket, string, string2) + (bl ? "---- not thrown ----" : "")});
                serializable = iOException;
            }
        }
        try {
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException, new String[]{this.getDriver().objectInfo(serverBucket, string, string2) + (bl ? "---- not thrown ----" : "")});
            serializable = iOException;
        }
        if (!bl && serializable != null) {
            throw new InternalCriticalException(serializable);
        }
        return l;
        catch (Exception exception) {
            try {
                bl = true;
                throw new InternalCriticalException(exception, this.getDriver().objectInfo(serverBucket, string, string2));
            }
            catch (Throwable throwable) {
                IOException iOException = null;
                if (bufferedOutputStreamArray != null) {
                    try {
                        for (int i = 0; i < n2; ++i) {
                            if (bufferedOutputStreamArray[i] == null) continue;
                            bufferedOutputStreamArray[i].close();
                        }
                    }
                    catch (IOException iOException3) {
                        logger.error((Throwable)iOException3, new String[]{this.getDriver().objectInfo(serverBucket, string, string2) + (bl ? "---- not thrown ----" : "")});
                        iOException = iOException3;
                    }
                }
                try {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (IOException iOException4) {
                    logger.error((Throwable)iOException4, new String[]{this.getDriver().objectInfo(serverBucket, string, string2) + (bl ? "---- not thrown ----" : "")});
                    iOException = iOException4;
                }
                if (!bl && iOException != null) {
                    throw new InternalCriticalException(iOException);
                }
                throw throwable;
            }
        }
    }

    private void saveObjectMetadata(ObjectMetadata objectMetadata) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        for (Drive drive : this.getDriver().getDrivesAll()) {
            drive.saveObjectMetadata(objectMetadata);
        }
    }

    private void saveObjectMetadata(ServerBucket serverBucket, String string, String string2, String string3, int n, Optional<List<String>> optional) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        String string4 = null;
        String string5 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Drive drive : this.getDriver().getDrivesAll()) {
            String string6;
            ObjectPath objectPath = new ObjectPath(drive, serverBucket, string);
            File file = objectPath.dataFilePath().toFile();
            try {
                String string7 = OdilonFileUtils.calculateSHA256String((File)file);
                if (string4 == null) {
                    string4 = string7;
                    string5 = drive.getName();
                } else if (!string7.equals(string4)) {
                    throw new InternalCriticalException("SHA 256 are not equal for drives -> " + string5 + ":" + string4 + " vs " + drive.getName() + ":" + string7);
                }
                string6 = new ObjectMetadata(serverBucket.getId(), string);
                ((ObjectMetadata)string6).fileName = string2;
                ((ObjectMetadata)string6).appVersion = "1.15";
                ((ObjectMetadata)string6).contentType = string3;
                ((ObjectMetadata)string6).encrypt = this.getVirtualFileSystemService().isEncrypt();
                ((ObjectMetadata)string6).vault = this.getVirtualFileSystemService().isUseVaultNewFiles();
                ((ObjectMetadata)string6).creationDate = offsetDateTime;
                ((ObjectMetadata)string6).version = n;
                ((ObjectMetadata)string6).versioncreationDate = ((ObjectMetadata)string6).creationDate;
                ((ObjectMetadata)string6).length = file.length();
                ((ObjectMetadata)string6).etag = string7;
                ((ObjectMetadata)string6).integrityCheck = offsetDateTime;
                ((ObjectMetadata)string6).sha256 = string7;
                ((ObjectMetadata)string6).status = ObjectStatus.ENABLED;
                ((ObjectMetadata)string6).drive = drive.getName();
                ((ObjectMetadata)string6).raid = String.valueOf(this.getRedundancyLevel().getCode()).trim();
                if (optional.isPresent()) {
                    ((ObjectMetadata)string6).customTags = optional.get();
                }
                arrayList.add(string6);
            }
            catch (Exception exception) {
                string6 = this.getDriver().objectInfo(serverBucket, string, string2);
                logger.error((Throwable)exception, new String[]{string6});
                throw new InternalCriticalException(exception, string6);
            }
        }
        this.saveRAIDOneObjectMetadataToDisk(this.getDriver().getDrivesAll(), arrayList, true);
    }

    private boolean restoreVersionObjectMetadata(ServerBucket serverBucket, String string, int n) {
        try {
            boolean bl = true;
            for (Drive drive : this.getDriver().getDrivesAll()) {
                File file = drive.getObjectMetadataVersionFile(serverBucket, string, n);
                if (file.exists()) {
                    drive.putObjectMetadataFile(serverBucket, string, file);
                    FileUtils.deleteQuietly((File)file);
                    continue;
                }
                bl = false;
            }
            return bl;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.getDriver().objectInfo(serverBucket, string));
        }
    }

    private boolean restoreVersionObjectDataFile(ServerBucket serverBucket, String string, int n) {
        try {
            boolean bl = true;
            for (Drive drive : this.getDriver().getDrivesAll()) {
                ObjectPath objectPath = new ObjectPath(drive, serverBucket, string);
                File file = objectPath.dataFileVersionPath(n).toFile();
                if (file.exists()) {
                    ((SimpleDrive)drive).putObjectDataFile(serverBucket.getId(), string, file);
                    FileUtils.deleteQuietly((File)file);
                    continue;
                }
                bl = false;
            }
            return bl;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.getDriver().objectInfo(serverBucket, string));
        }
    }

    private void cleanUpRestoreVersion(VirtualFileSystemOperation virtualFileSystemOperation, ServerBucket serverBucket, String string, int n) {
        if (virtualFileSystemOperation == null || n < 0) {
            return;
        }
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                FileUtils.deleteQuietly((File)drive.getObjectMetadataVersionFile(serverBucket, string, n));
                ObjectPath objectPath = new ObjectPath(drive, serverBucket, string);
                FileUtils.deleteQuietly((File)objectPath.dataFileVersionPath(n).toFile());
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private void backupMetadata(ObjectMetadata objectMetadata, ServerBucket serverBucket) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                String string = drive.getObjectMetadataDirPath(serverBucket, objectMetadata.objectName);
                String string2 = drive.getBucketWorkDirPath(serverBucket) + File.separator + objectMetadata.objectName;
                File file = new File(string);
                if (!file.exists()) continue;
                FileUtils.copyDirectory((File)file, (File)new File(string2));
            }
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, objectMetadata.toString());
        }
    }

    private void cleanUpUpdate(VirtualFileSystemOperation virtualFileSystemOperation, ServerBucket serverBucket, String string, int n, int n2) {
        if (virtualFileSystemOperation == null) {
            return;
        }
        try {
            Check.requireNonNullArgument((Object)serverBucket, (String)"meta is null");
            if (!this.getVirtualFileSystemService().getServerSettings().isVersionControl()) {
                for (Drive drive : this.getDriver().getDrivesAll()) {
                    FileUtils.deleteQuietly((File)drive.getObjectMetadataVersionFile(serverBucket, string, n));
                    ObjectPath objectPath = new ObjectPath(drive, serverBucket, string);
                    File file = objectPath.dataFileVersionPath(n).toFile();
                    FileUtils.deleteQuietly((File)file);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private void cleanUpBackupMetadataDir(ServerBucket serverBucket, String string) {
        try {
            if (serverBucket == null) {
                return;
            }
            for (Drive drive : this.getDriver().getDrivesAll()) {
                FileUtils.deleteQuietly((File)new File(drive.getBucketWorkDirPath(serverBucket) + File.separator + string));
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{this.objectInfo(serverBucket, string), "---- not thrown ----"});
        }
    }

    private static /* synthetic */ Boolean lambda$saveObjectDataFile$0(BufferedOutputStream[] bufferedOutputStreamArray, int n, byte[] byArray, int n2) throws Exception {
        try {
            bufferedOutputStreamArray[n].write(byArray, 0, n2);
            return true;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            return false;
        }
    }
}

