/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import io.odilon.encryption.EncryptedResult;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ObjectStatus;
import io.odilon.util.Check;
import io.odilon.util.OdilonFileUtils;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid6.RAIDSixBlocks;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.RAIDSixEncoder;
import io.odilon.virtualFileSystem.raid6.RAIDSixTransactionObjectHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RAIDSixCreateObjectHandler
extends RAIDSixTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDSixCreateObjectHandler.class.getName());

    protected RAIDSixCreateObjectHandler(RAIDSixDriver rAIDSixDriver, ServerBucket serverBucket, String string) {
        super(rAIDSixDriver, serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void create(InputStream inputStream, String string, String string2, Optional<List<String>> optional) {
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl = false;
        boolean bl2 = false;
        this.objectWriteLock();
        try {
            this.bucketReadLock();
            try (InputStream inputStream2 = inputStream;){
                this.checkExistsBucket();
                this.checkNotExistObject();
                virtualFileSystemOperation = this.createObject();
                RAIDSixBlocks rAIDSixBlocks = this.saveData(inputStream);
                this.saveMetadata(rAIDSixBlocks, string, string2, optional);
                bl = virtualFileSystemOperation.commit();
            }
            catch (InternalCriticalException internalCriticalException) {
                try {
                    bl2 = true;
                    throw internalCriticalException;
                    catch (Exception exception) {
                        bl2 = true;
                        throw new InternalCriticalException(exception, this.info(string));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (bl) throw throwable;
                        try {
                            this.rollback(virtualFileSystemOperation);
                            throw throwable;
                        }
                        catch (Exception exception) {
                            if (!bl2) throw new InternalCriticalException(exception, this.info());
                            logger.error(new String[]{this.info(string), "---- not thrown ----"});
                            throw throwable;
                        }
                    }
                    finally {
                        this.bucketReadUnLock();
                    }
                }
            }
            try {
                if (bl) return;
                try {
                    this.rollback(virtualFileSystemOperation);
                    return;
                }
                catch (Exception exception) {
                    if (!bl2) throw new InternalCriticalException(exception, this.info());
                    logger.error(new String[]{this.info(string), "---- not thrown ----"});
                    return;
                }
            }
            finally {
                this.bucketReadUnLock();
            }
        }
        finally {
            this.objectWriteUnLock();
        }
    }

    private VirtualFileSystemOperation createObject() {
        return this.createObject(this.getBucket(), this.getObjectName());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RAIDSixBlocks saveData(InputStream inputStream) {
        IOException iOException;
        RAIDSixBlocks rAIDSixBlocks;
        Check.requireNonNullArgument((Object)inputStream, (String)"stream is null");
        if (this.isEncrypt()) {
            IOException iOException2;
            RAIDSixBlocks rAIDSixBlocks2;
            boolean bl = false;
            InputStream inputStream2 = null;
            try {
                EncryptedResult encryptedResult = this.getEncryptionService().encryptStream(inputStream);
                inputStream2 = encryptedResult.getInputStream();
                RAIDSixEncoder rAIDSixEncoder = new RAIDSixEncoder(this.getDriver());
                RAIDSixBlocks rAIDSixBlocks3 = rAIDSixEncoder.encodeHead(inputStream2, this.getBucket(), this.getObjectName());
                long l = encryptedResult.getCountingStream().getCount();
                rAIDSixBlocks3.setSrcFileSize(l);
                rAIDSixBlocks2 = rAIDSixBlocks3;
                iOException2 = null;
            }
            catch (InternalCriticalException internalCriticalException) {
                try {
                    bl = true;
                    throw internalCriticalException;
                    catch (Exception exception) {
                        bl = true;
                        throw new InternalCriticalException(exception, this.objectInfo(this.getBucket(), this.getObjectName()));
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException3 = null;
                    try {
                        if (inputStream2 != null) {
                            inputStream2.close();
                        }
                    }
                    catch (IOException iOException4) {
                        logger.error((Throwable)iOException4, new String[]{this.objectInfo(this.getBucket(), this.getObjectName()) + (bl ? "---- not thrown ----" : "")});
                        iOException3 = iOException4;
                    }
                    if (!bl && iOException3 != null) {
                        throw new InternalCriticalException(iOException3);
                    }
                    throw throwable;
                }
            }
            try {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
            catch (IOException iOException5) {
                logger.error((Throwable)iOException5, new String[]{this.objectInfo(this.getBucket(), this.getObjectName()) + (bl ? "---- not thrown ----" : "")});
                iOException2 = iOException5;
            }
            if (!bl && iOException2 != null) {
                throw new InternalCriticalException(iOException2);
            }
            return rAIDSixBlocks2;
        }
        boolean bl = false;
        InputStream inputStream3 = null;
        try {
            inputStream3 = inputStream;
            RAIDSixEncoder rAIDSixEncoder = new RAIDSixEncoder(this.getDriver());
            RAIDSixBlocks rAIDSixBlocks4 = rAIDSixEncoder.encodeHead(inputStream3, this.getBucket(), this.getObjectName());
            long l = rAIDSixBlocks4.getFileSize();
            rAIDSixBlocks4.setSrcFileSize(l);
            rAIDSixBlocks = rAIDSixBlocks4;
            iOException = null;
        }
        catch (InternalCriticalException internalCriticalException) {
            try {
                bl = true;
                throw internalCriticalException;
                catch (Exception exception) {
                    bl = true;
                    throw new InternalCriticalException(exception, this.objectInfo(this.getBucket(), this.getObjectName()));
                }
            }
            catch (Throwable throwable) {
                IOException iOException6 = null;
                try {
                    if (inputStream3 != null) {
                        inputStream3.close();
                    }
                }
                catch (IOException iOException7) {
                    logger.error((Throwable)iOException7, new String[]{this.objectInfo(this.getBucket(), this.getObjectName()) + (bl ? "---- not thrown ----" : "")});
                    iOException6 = iOException7;
                }
                if (!bl && iOException6 != null) {
                    throw new InternalCriticalException(iOException6);
                }
                throw throwable;
            }
        }
        try {
            if (inputStream3 != null) {
                inputStream3.close();
            }
        }
        catch (IOException iOException8) {
            logger.error((Throwable)iOException8, new String[]{this.objectInfo(this.getBucket(), this.getObjectName()) + (bl ? "---- not thrown ----" : "")});
            iOException = iOException8;
        }
        if (!bl && iOException != null) {
            throw new InternalCriticalException(iOException);
        }
        return rAIDSixBlocks;
    }

    private void saveMetadata(RAIDSixBlocks rAIDSixBlocks, String string2, String string3, Optional<List<String>> optional) {
        ArrayList arrayList = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        rAIDSixBlocks.getEncodedBlocks().forEach(file -> {
            try {
                arrayList.add(OdilonFileUtils.calculateSHA256String((File)file));
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.info());
            }
        });
        arrayList.forEach(string -> stringBuilder.append((String)string));
        String string4 = null;
        try {
            string4 = OdilonFileUtils.calculateSHA256String((String)stringBuilder.toString());
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            throw new InternalCriticalException(exception, this.info(string2));
        }
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        List list = this.getDriver().getDrivesAll();
        ArrayList<ObjectMetadata> arrayList2 = new ArrayList<ObjectMetadata>();
        for (Drive drive : this.getDriver().getDrivesAll()) {
            try {
                ObjectMetadata objectMetadata = new ObjectMetadata(this.getBucket().getId(), this.getObjectName());
                objectMetadata.setFileName(string2);
                objectMetadata.setAppVersion("1.15");
                objectMetadata.setContentType(string3);
                objectMetadata.setCreationDate(offsetDateTime);
                objectMetadata.setVersion(0);
                objectMetadata.setVersioncreationDate(objectMetadata.getCreationDate());
                objectMetadata.setSourceLength(rAIDSixBlocks.getSrcFileSize());
                objectMetadata.setLength(rAIDSixBlocks.getFileSize());
                objectMetadata.setSha256Blocks(arrayList);
                objectMetadata.setTotalBlocks(rAIDSixBlocks.getEncodedBlocks().size());
                objectMetadata.setEtag(string4);
                objectMetadata.setEncrypt(this.getVirtualFileSystemService().isEncrypt());
                objectMetadata.setIntegrityCheck(objectMetadata.getCreationDate());
                objectMetadata.setStatus(ObjectStatus.ENABLED);
                objectMetadata.setDrive(drive.getName());
                objectMetadata.setRaid(String.valueOf(this.getRedundancyLevel().getCode()).trim());
                objectMetadata.setRaidDrives(this.getDriver().getTotalDisks());
                if (optional.isPresent()) {
                    objectMetadata.setCustomTags(optional.get());
                }
                arrayList2.add(objectMetadata);
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.info(string2));
            }
        }
        this.saveRAIDSixObjectMetadataToDisk(list, arrayList2, true);
    }
}

