/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.io.Files;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.OdilonServerInfo;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.DriveStatus;
import io.odilon.virtualFileSystem.model.IODriveSetup;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriveSync;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RAIDSixDriveSetup
implements IODriveSetup,
ApplicationContextAware {
    private static Logger logger = Logger.getLogger((String)RAIDSixDriveSetup.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private RAIDSixDriver driver;
    @JsonIgnore
    private AtomicLong checkOk = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong counter = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong moved = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong totalBytesMoved = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong totalBytesCleaned = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong errors = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong cleaned = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong notAvailable = new AtomicLong(0L);
    @JsonIgnore
    int maxProcessingThread;
    @JsonIgnore
    private long start_ms;
    @JsonIgnore
    private long start_move;
    @JsonIgnore
    private long start_cleanup;
    @JsonIgnore
    private List<Drive> listEnabledBefore = new ArrayList();
    @JsonIgnore
    private List<Drive> listAllBefore = new ArrayList();
    @JsonIgnore
    private ApplicationContext applicationContext;

    public RAIDSixDriveSetup(RAIDSixDriver rAIDSixDriver) {
        this.driver = rAIDSixDriver;
    }

    public boolean setup() {
        String string;
        startuplogger.info("This process is async for RAID 6");
        startuplogger.info("It will start a background process to setup the new drives.");
        startuplogger.info("The background process will copy all objects into the newly added drives");
        OdilonServerInfo odilonServerInfo = this.getDriver().getServerInfo();
        File file = ((Drive)this.getDriver().getDrivesEnabled().get(0)).getSysFile("key.enc");
        try {
            string = this.getDriver().getObjectMapper().writeValueAsString((Object)odilonServerInfo);
        }
        catch (JsonProcessingException jsonProcessingException) {
            startuplogger.error((Throwable)jsonProcessingException, new String[]{"---- not thrown ----"});
            return false;
        }
        try {
            startuplogger.info("1. Copying -> odilon.json");
            this.getDriver().getDrivesAll().forEach(drive -> {
                File file = drive.getSysFile("odilon.json");
                if (!(drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC || file != null && file.exists())) {
                    try {
                        drive.putSysFile("odilon.json", string);
                    }
                    catch (Exception exception) {
                        startuplogger.error((Throwable)exception, new String[]{"Drive -> " + drive.getName()});
                        throw new InternalCriticalException(exception, "Drive -> " + drive.getName());
                    }
                }
            });
            if (file != null && file.exists()) {
                startuplogger.info("2. Copying -> key.enc");
                this.getDriver().getDrivesAll().forEach(drive -> {
                    File file2 = drive.getSysFile("key.enc");
                    if (!(drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC || file2 != null && file2.exists())) {
                        try {
                            Files.copy((File)file, (File)file2);
                        }
                        catch (Exception exception) {
                            throw new InternalCriticalException(exception, "Drive -> " + drive.getName());
                        }
                    }
                });
            } else {
                startuplogger.info("2. Copying -> key.enc | file not exist. skipping");
            }
        }
        catch (Exception exception) {
            startuplogger.error((Throwable)exception, new String[]{"---- not thrown ----"});
            startuplogger.error(new String[]{"The process can not be completed due to errors"});
            return false;
        }
        this.createBuckets();
        if (this.errors.get() > 0L || this.notAvailable.get() > 0L) {
            startuplogger.error(new String[]{"The process can not be completed due to errors"});
            return false;
        }
        startuplogger.info("4. Starting Async process -> " + RAIDSixDriveSync.class.getSimpleName());
        RAIDSixDriveSync rAIDSixDriveSync = (RAIDSixDriveSync)this.getApplicationContext().getBean(RAIDSixDriveSync.class, new Object[]{this.getDriver()});
        startuplogger.info("done");
        return true;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void createBuckets() {
        List list = this.getDriver().getVirtualFileSystemService().listAllBuckets();
        startuplogger.info("3. Creating " + String.valueOf(list.size()) + " Buckets");
        for (ServerBucket serverBucket : list) {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                if (drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC) continue;
                try {
                    if (drive.existsBucketById(serverBucket.getId())) continue;
                    drive.createBucket(serverBucket.getBucketMetadata());
                }
                catch (Exception exception) {
                    this.errors.getAndIncrement();
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    return;
                }
            }
        }
    }

    private RAIDSixDriver getDriver() {
        return this.driver;
    }
}

