/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ServiceStatus;
import io.odilon.model.list.DataList;
import io.odilon.model.list.Item;
import io.odilon.virtualFileSystem.DriveInfo;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.DriveStatus;
import io.odilon.virtualFileSystem.model.LockService;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemService;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import jakarta.annotation.PostConstruct;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RAIDSixDriveSync
implements Runnable {
    private static Logger logger = Logger.getLogger((String)RAIDSixDriveSync.class.getName());
    private static Logger startuplogger = Logger.getLogger((String)"StartupLogger");
    @JsonIgnore
    private List<Drive> drives = new ArrayList();
    @JsonIgnore
    private AtomicBoolean bucketsCreated = new AtomicBoolean(false);
    @JsonIgnore
    private AtomicLong checkOk = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong counter = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong encoded = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong totalBytes = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong errors = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong cleaned = new AtomicLong(0L);
    @JsonIgnore
    private AtomicLong notAvailable = new AtomicLong(0L);
    @JsonIgnore
    private RAIDSixDriver driver;
    @JsonIgnore
    private Thread thread;
    @JsonIgnore
    private AtomicBoolean done;
    @JsonIgnore
    private LockService vfsLockService;
    private OffsetDateTime dateConnected;

    public RAIDSixDriveSync(RAIDSixDriver rAIDSixDriver) {
        this.driver = rAIDSixDriver;
        this.vfsLockService = this.driver.getLockService();
    }

    public AtomicBoolean isDone() {
        return this.done;
    }

    public AtomicLong getErrors() {
        return this.errors;
    }

    public AtomicLong getNnotAvailable() {
        return this.notAvailable;
    }

    @Override
    public void run() {
        logger.info("Starting -> " + this.getClass().getSimpleName());
        long l = System.currentTimeMillis();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this.getDriver().getVirtualFileSystemService().getStatus() != ServiceStatus.RUNNING) {
            startuplogger.info("waiting for " + VirtualFileSystemService.class.getSimpleName() + " to startup (" + String.valueOf(Double.valueOf(System.currentTimeMillis() - l) / Double.valueOf(1000.0)) + " secs)");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.encode();
        if (this.errors.get() > 0L || this.notAvailable.get() > 0L) {
            startuplogger.error(new String[]{"The process can not be completed due to errors"});
            startuplogger.error(new String[]{"---------------------------------"});
            return;
        }
        this.updateDrives();
        this.done = new AtomicBoolean(true);
    }

    @PostConstruct
    public void onInitialize() {
        this.thread = new Thread((Runnable)this);
        this.thread.setDaemon(true);
        this.thread.setName(this.getClass().getSimpleName());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encode() {
        logger.debug("Starting Drive init: ");
        this.getDriver().getDrivesAll().stream().filter(drive -> drive.getDriveInfo().getStatus() == DriveStatus.NOTSYNC).forEach(drive -> logger.debug("d:" + drive.getName() + "  dir:" + drive.getRootDirPath()));
        long l = System.currentTimeMillis();
        int n = Double.valueOf(Double.valueOf(Runtime.getRuntime().availableProcessors() - 1) / 2.0).intValue() + 1;
        this.getDriver().getDrivesAll().forEach(drive -> this.drives.add(drive));
        this.drives.sort(new /* Unavailable Anonymous Inner Class!! */);
        this.dateConnected = this.getDriver().getVirtualFileSystemService().getMapDrivesAll().values().stream().filter(drive -> drive.getDriveInfo().getStatus() == DriveStatus.NOTSYNC).map(drive -> drive.getDriveInfo().getDateConnected()).reduce(OffsetDateTime.MIN, (offsetDateTime, offsetDateTime2) -> offsetDateTime.isAfter((OffsetDateTime)offsetDateTime2) ? offsetDateTime : offsetDateTime2);
        ExecutorService executorService = null;
        try {
            this.errors = new AtomicLong(0L);
            executorService = Executors.newFixedThreadPool(n);
            for (ServerBucket serverBucket : this.getDriver().getVirtualFileSystemService().listAllBuckets()) {
                Integer n2 = 1000;
                Long l2 = 0L;
                String string = null;
                boolean bl = false;
                while (!bl) {
                    DataList dataList = this.getDriver().getVirtualFileSystemService().listObjects(serverBucket.getName(), Optional.of(l2), Optional.ofNullable(n2), Optional.empty(), Optional.ofNullable(string));
                    if (string == null) {
                        string = dataList.getAgentId();
                    }
                    ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>(dataList.getList().size());
                    for (Item item : dataList.getList()) {
                        arrayList.add(() -> {
                            try {
                                this.counter.getAndIncrement();
                                if (this.counter.get() % 50L == 0L) {
                                    logger.debug("scanned (encoded) so far -> " + String.valueOf(this.counter.get()));
                                }
                                if (item.isOk()) {
                                    if (this.requireSync(item)) {
                                        this.getDriver().syncObject((ObjectMetadata)item.getObject());
                                        this.encoded.incrementAndGet();
                                    }
                                } else {
                                    this.notAvailable.getAndIncrement();
                                }
                            }
                            catch (Exception exception) {
                                logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                                this.errors.getAndIncrement();
                            }
                            return null;
                        });
                    }
                    try {
                        executorService.invokeAll(arrayList, 10L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error((Throwable)interruptedException, new String[]{"---- not thrown ----"});
                    }
                    l2 = l2 + Long.valueOf(Integer.valueOf(dataList.getList().size()).longValue());
                    bl = dataList.isEOD() || this.errors.get() > 0L || this.notAvailable.get() > 0L;
                }
            }
            try {
                executorService.shutdown();
                executorService.awaitTermination(15L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            startuplogger.info("---------------------------------");
            startuplogger.info(this.getClass().getSimpleName() + " Process completed");
            startuplogger.debug("Threads: " + String.valueOf(n));
            startuplogger.info("Total read: " + String.valueOf(this.counter.get()));
            startuplogger.info("Total encoded: " + String.valueOf(this.encoded.get()));
            if (this.errors.get() > 0L) {
                startuplogger.info("Errors: " + String.valueOf(this.errors.get()));
            }
            if (this.notAvailable.get() > 0L) {
                startuplogger.info("Not Available: " + String.valueOf(this.notAvailable.get()));
            }
            startuplogger.info("Duration: " + String.valueOf(Double.valueOf(System.currentTimeMillis() - l) / Double.valueOf(1000.0)) + " secs");
            startuplogger.info("---------------------------------");
        }
    }

    protected RAIDSixDriver getDriver() {
        return this.driver;
    }

    protected LockService getLockService() {
        return this.vfsLockService;
    }

    protected List<Drive> getDrives() {
        return this.drives;
    }

    private void updateDrives() {
        for (Drive drive : this.getDriver().getDrivesAll()) {
            if (drive.getDriveInfo().getStatus() != DriveStatus.NOTSYNC) continue;
            DriveInfo driveInfo = drive.getDriveInfo();
            driveInfo.setStatus(DriveStatus.ENABLED);
            driveInfo.setOrder(drive.getConfigOrder());
            drive.setDriveInfo(driveInfo);
            this.getDriver().getVirtualFileSystemService().updateDriveStatus(drive);
            startuplogger.debug("Drive synced -> " + drive.toString());
        }
    }

    private boolean requireSync(Item<ObjectMetadata> item) {
        return ((ObjectMetadata)item.getObject()).lastModified.isBefore(this.dateConnected);
    }
}

