/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.RAIDSixRollbackHandler;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class RAIDSixRollbackDeleteHandler
extends RAIDSixRollbackHandler {
    private static Logger logger = Logger.getLogger((String)RAIDSixRollbackDeleteHandler.class.getName());

    public RAIDSixRollbackDeleteHandler(RAIDSixDriver rAIDSixDriver, VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        super(rAIDSixDriver, virtualFileSystemOperation, bl);
    }

    protected void rollback() {
        boolean bl = false;
        try {
            this.restoreMetadata();
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error((Throwable)internalCriticalException, new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception);
            }
            logger.error((Throwable)exception, new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }

    private void restoreMetadata() {
        ServerBucket serverBucket = this.getBucketCache().get(this.getOperation().getBucketId());
        String string = this.getOperation().getObjectName();
        for (Drive drive : this.getDriver().getDrivesAll()) {
            String string2 = drive.getBucketWorkDirPath(serverBucket) + File.separator + string;
            String string3 = drive.getObjectMetadataDirPath(serverBucket, string);
            try {
                if (!new File(string2).exists()) continue;
                FileUtils.copyDirectory((File)new File(string2), (File)new File(string3));
            }
            catch (IOException iOException) {
                throw new InternalCriticalException((Exception)iOException, this.objectInfo(serverBucket, string));
            }
        }
    }
}

