/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.RAIDSixRollbackHandler;
import io.odilon.virtualFileSystem.raid6.RAIDSixRollbackUpdateHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RAIDSixRollbackUpdateHandler
extends RAIDSixRollbackHandler {
    private static Logger logger = Logger.getLogger((String)RAIDSixRollbackUpdateHandler.class.getName());

    public RAIDSixRollbackUpdateHandler(RAIDSixDriver rAIDSixDriver, VirtualFileSystemOperation virtualFileSystemOperation, boolean bl) {
        super(rAIDSixDriver, virtualFileSystemOperation, bl);
    }

    protected void rollback() {
        switch (1.$SwitchMap$io$odilon$virtualFileSystem$model$OperationCode[this.getOperation().getOperationCode().ordinal()]) {
            case 1: {
                this.rollbackUpdate();
                break;
            }
            case 2: {
                this.rollbackUpdateMetadata();
                break;
            }
            case 3: {
                this.rollbackUpdate();
                break;
            }
            default: {
                throw new IllegalArgumentException(" not supported -> " + this.opInfo(this.getOperation()));
            }
        }
    }

    private void rollbackUpdateMetadata() {
        boolean bl = false;
        try {
            this.restoreVersionObjectMetadata();
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error(new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.opInfo(this.getOperation()));
            }
            logger.error(new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }

    private void rollbackUpdate() {
        boolean bl = false;
        try {
            this.restoreVersionObjectDataFile();
            this.restoreVersionObjectMetadata();
            bl = true;
        }
        catch (InternalCriticalException internalCriticalException) {
            if (!this.isRecovery()) {
                throw internalCriticalException;
            }
            logger.error((Throwable)internalCriticalException, new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        catch (Exception exception) {
            if (!this.isRecovery()) {
                throw new InternalCriticalException(exception, this.opInfo(this.getOperation()));
            }
            logger.error((Throwable)exception, new String[]{this.opInfo(this.getOperation()), "---- not thrown ----"});
        }
        finally {
            if (bl || this.isRecovery()) {
                this.getOperation().cancel();
            }
        }
    }

    private boolean restoreVersionObjectMetadata() {
        try {
            boolean bl = true;
            ServerBucket serverBucket = this.getBucketCache().get(this.getOperation().getBucketId());
            ObjectMetadata objectMetadata = this.getDriver().getObjectMetadataVersion(serverBucket, this.getOperation().getObjectName(), this.getOperation().getVersion());
            for (Drive drive : this.getDriver().getDrivesAll()) {
                objectMetadata.setDrive(drive.getName());
                drive.saveObjectMetadata(objectMetadata);
            }
            return bl;
        }
        catch (InternalCriticalException internalCriticalException) {
            throw internalCriticalException;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.opInfo(this.getOperation()));
        }
    }

    private boolean restoreVersionObjectDataFile() {
        try {
            ServerBucket serverBucket = this.getBucketCache().get(this.getOperation().getBucketId());
            ObjectMetadata objectMetadata = this.getDriver().getObjectMetadataVersion(serverBucket, this.getOperation().getObjectName(), this.getOperation().getVersion());
            Map map = this.getDriver().getObjectDataFilesNames(objectMetadata, Optional.of(this.getOperation().getVersion()));
            for (Drive drive : map.keySet()) {
                for (String string : (List)map.get(drive)) {
                    String[] stringArray = string.split(".v");
                    String string2 = stringArray[0];
                    try {
                        if (!new File(drive.getBucketObjectDataDirPath(serverBucket) + File.separator + "version", string).exists()) continue;
                        Files.copy(new File(drive.getBucketObjectDataDirPath(serverBucket) + File.separator + "version", string).toPath(), new File(drive.getBucketObjectDataDirPath(serverBucket), string2).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException iOException) {
                        throw new InternalCriticalException((Exception)iOException, this.opInfo(this.getOperation()));
                    }
                }
            }
            return true;
        }
        catch (InternalCriticalException internalCriticalException) {
            throw internalCriticalException;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.opInfo(this.getOperation()));
        }
    }
}

