/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import io.odilon.encryption.EncryptedResult;
import io.odilon.error.OdilonObjectNotFoundException;
import io.odilon.errors.InternalCriticalException;
import io.odilon.log.Logger;
import io.odilon.model.ObjectMetadata;
import io.odilon.model.ObjectStatus;
import io.odilon.util.Check;
import io.odilon.util.OdilonFileUtils;
import io.odilon.virtualFileSystem.model.Drive;
import io.odilon.virtualFileSystem.model.ServerBucket;
import io.odilon.virtualFileSystem.model.VirtualFileSystemOperation;
import io.odilon.virtualFileSystem.raid6.RAIDSixBlocks;
import io.odilon.virtualFileSystem.raid6.RAIDSixDriver;
import io.odilon.virtualFileSystem.raid6.RAIDSixEncoder;
import io.odilon.virtualFileSystem.raid6.RAIDSixTransactionObjectHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;

@ThreadSafe
public class RAIDSixUpdateObjectHandler
extends RAIDSixTransactionObjectHandler {
    private static Logger logger = Logger.getLogger((String)RAIDSixUpdateObjectHandler.class.getName());

    protected RAIDSixUpdateObjectHandler(RAIDSixDriver rAIDSixDriver, ServerBucket serverBucket, String string) {
        super(rAIDSixDriver, serverBucket, string);
    }

    protected boolean existsObjectMetadata(ServerBucket serverBucket, String string) {
        if (this.existsCacheObject(serverBucket, string)) {
            return true;
        }
        return this.getDriver().getObjectMetadataReadDrive(serverBucket, string).existsObjectMetadata(serverBucket, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(ServerBucket serverBucket, String string, InputStream inputStream, String string2, String string3, Optional<List<String>> optional) {
        String string4 = serverBucket.getName();
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = -1;
        ObjectMetadata objectMetadata = null;
        this.getLockService().getObjectLock(serverBucket, string).writeLock().lock();
        try {
            this.getLockService().getBucketLock(serverBucket).readLock().lock();
            try (InputStream inputStream2 = inputStream;){
                this.checkExistsBucket(serverBucket);
                this.checkExistObject(serverBucket, string);
                objectMetadata = this.getMetadata(serverBucket, string, true);
                n = objectMetadata.getVersion();
                this.backupVersionObjectDataFile(objectMetadata, serverBucket, objectMetadata.getVersion());
                this.backupVersionObjectMetadata(serverBucket, string, objectMetadata.getVersion());
                virtualFileSystemOperation = this.getJournalService().updateObject(serverBucket, string, n);
                n2 = objectMetadata.getVersion() + 1;
                RAIDSixBlocks rAIDSixBlocks = this.saveObjectDataFile(serverBucket, string, inputStream);
                this.saveObjectMetadata(serverBucket, string, rAIDSixBlocks, string2, string3, n2, objectMetadata.getCreationDate(), optional);
                bl = virtualFileSystemOperation.commit();
            }
            catch (Exception exception) {
                try {
                    bl2 = true;
                    throw new InternalCriticalException(exception, this.objectInfo(string4, string, string2));
                }
                catch (Throwable throwable) {
                    try {
                        if (!bl) {
                            try {
                                this.rollback(virtualFileSystemOperation);
                                throw throwable;
                            }
                            catch (Exception exception2) {
                                if (bl2) {
                                    throw new InternalCriticalException(exception2, this.objectInfo(string4, string, string2));
                                }
                                logger.error(new String[]{this.objectInfo(string4, string, string2), "---- not thrown ----"});
                                throw throwable;
                            }
                        }
                        this.cleanUpUpdate(objectMetadata, serverBucket, n, n2);
                        throw throwable;
                    }
                    finally {
                        this.getLockService().getBucketLock(serverBucket).readLock().unlock();
                    }
                }
            }
            try {
                if (!bl) {
                    try {
                        this.rollback(virtualFileSystemOperation);
                        return;
                    }
                    catch (Exception exception) {
                        if (bl2) {
                            throw new InternalCriticalException(exception, this.objectInfo(string4, string, string2));
                        }
                        logger.error(new String[]{this.objectInfo(string4, string, string2), "---- not thrown ----"});
                        return;
                    }
                }
                this.cleanUpUpdate(objectMetadata, serverBucket, n, n2);
                return;
            }
            finally {
                this.getLockService().getBucketLock(serverBucket).readLock().unlock();
            }
        }
        finally {
            this.getLockService().getObjectLock(serverBucket, string).writeLock().unlock();
        }
    }

    protected void updateObjectMetadataHeadVersion(ObjectMetadata objectMetadata) {
        this.updateObjectMetadata(objectMetadata, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateObjectMetadata(ObjectMetadata objectMetadata, boolean bl) {
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl2 = false;
        ServerBucket serverBucket = null;
        this.getLockService().getObjectLock(objectMetadata.getBucketId(), objectMetadata.getObjectName()).writeLock().lock();
        try {
            this.getLockService().getBucketLock(objectMetadata.getBucketId()).readLock().lock();
            try {
                this.checkExistsBucket(objectMetadata.getBucketId());
                serverBucket = this.getBucketCache().get(objectMetadata.getBucketId());
                this.checkExistObject(serverBucket, objectMetadata.getObjectName());
                this.backup(objectMetadata, serverBucket);
                virtualFileSystemOperation = this.getJournalService().updateObjectMetadata(serverBucket, objectMetadata.getObjectName(), objectMetadata.getVersion());
                this.saveObjectMetadata(objectMetadata, bl);
                bl2 = virtualFileSystemOperation.commit();
            }
            catch (Exception exception) {
                try {
                    bl2 = false;
                    throw new InternalCriticalException(exception, this.objectInfo(objectMetadata));
                }
                catch (Throwable throwable) {
                    try {
                        if (!bl2) {
                            try {
                                this.rollback(virtualFileSystemOperation);
                                throw throwable;
                            }
                            catch (Exception exception2) {
                                throw new InternalCriticalException(exception2, this.objectInfo(objectMetadata));
                            }
                        }
                        this.cleanUpBackupMetadataDir(serverBucket, objectMetadata.getObjectName());
                        throw throwable;
                    }
                    finally {
                        this.getLockService().getBucketLock(objectMetadata.getBucketId()).readLock().unlock();
                    }
                }
            }
            try {
                if (!bl2) {
                    try {
                        this.rollback(virtualFileSystemOperation);
                        return;
                    }
                    catch (Exception exception) {
                        throw new InternalCriticalException(exception, this.objectInfo(objectMetadata));
                    }
                }
                this.cleanUpBackupMetadataDir(serverBucket, objectMetadata.getObjectName());
                return;
            }
            finally {
                this.getLockService().getBucketLock(objectMetadata.getBucketId()).readLock().unlock();
            }
        }
        finally {
            this.getLockService().getObjectLock(objectMetadata.getBucketId(), objectMetadata.getObjectName()).writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ObjectMetadata restorePreviousVersion(ServerBucket serverBucket, String string) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        String string2 = serverBucket.getName();
        Check.requireNonNullArgument((Object)string2, (String)"bucketName is null");
        Check.requireNonNullArgument((Object)string, (String)("objectName is null or empty " + this.objectInfo(serverBucket)));
        VirtualFileSystemOperation virtualFileSystemOperation = null;
        boolean bl = false;
        int n = -1;
        boolean bl2 = false;
        ObjectMetadata objectMetadata = null;
        ObjectMetadata objectMetadata2 = null;
        this.getLockService().getObjectLock(serverBucket, string).writeLock().lock();
        try {
            this.getLockService().getBucketLock(serverBucket).readLock().lock();
            this.checkExistsBucket(serverBucket);
            this.checkExistObject(serverBucket, string);
            objectMetadata = this.getMetadata(serverBucket, string, false);
            if (objectMetadata == null || !objectMetadata.isAccesible()) {
                throw new OdilonObjectNotFoundException(this.objectInfo(serverBucket, string));
            }
            if (objectMetadata.getVersion() == 0) {
                throw new IllegalArgumentException("Object does not have versions -> " + this.objectInfo(serverBucket, string));
            }
            n = objectMetadata.getVersion();
            ArrayList<ObjectMetadata> arrayList = new ArrayList<ObjectMetadata>();
            for (int i = 0; i < n; ++i) {
                ObjectMetadata objectMetadata3 = this.getDriver().getObjectMetadataReadDrive(serverBucket, string).getObjectMetadataVersion(serverBucket, string, i);
                if (objectMetadata3 == null) continue;
                arrayList.add(objectMetadata3);
            }
            if (arrayList.isEmpty()) {
                throw new OdilonObjectNotFoundException(Optional.of(objectMetadata.systemTags).orElse("previous versions deleted"));
            }
            this.backupVersionObjectDataFile(objectMetadata, serverBucket, objectMetadata.getVersion());
            this.backupVersionObjectMetadata(serverBucket, string, objectMetadata.getVersion());
            virtualFileSystemOperation = this.getJournalService().restoreObjectPreviousVersion(serverBucket, string, n);
            objectMetadata2 = (ObjectMetadata)arrayList.get(arrayList.size() - 1);
            if (!this.restoreVersionObjectDataFile(objectMetadata2, serverBucket, objectMetadata2.getVersion())) {
                throw new OdilonObjectNotFoundException(Optional.of(objectMetadata.systemTags).orElse("previous versions deleted"));
            }
            if (!this.restoreVersionObjectMetadata(serverBucket, objectMetadata2.objectName, objectMetadata2.getVersion())) {
                throw new OdilonObjectNotFoundException(Optional.of(objectMetadata.systemTags).orElse("previous versions deleted"));
            }
            bl = virtualFileSystemOperation.commit();
            ObjectMetadata objectMetadata4 = objectMetadata2;
            try {
                if (!bl) {
                    try {
                        this.rollback(virtualFileSystemOperation);
                    }
                    catch (InternalCriticalException internalCriticalException) {
                        if (!bl2) {
                            throw new InternalCriticalException((Exception)((Object)internalCriticalException));
                        }
                        logger.error((Throwable)internalCriticalException, new String[]{this.objectInfo(string2, string), "---- not thrown ----"});
                    }
                    catch (Exception exception) {
                        if (!bl2) {
                            throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
                        }
                        logger.error((Throwable)exception, new String[]{this.objectInfo(serverBucket, string), "---- not thrown ----"});
                    }
                } else if (virtualFileSystemOperation != null && objectMetadata != null && objectMetadata2 != null) {
                    this.cleanUpRestoreVersion(objectMetadata, serverBucket, n, objectMetadata2);
                }
            }
            finally {
                this.getLockService().getBucketLock(serverBucket).readLock().unlock();
            }
            return objectMetadata4;
            catch (Exception exception) {
                try {
                    bl = false;
                    bl2 = true;
                    logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
                    throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
                }
                catch (Throwable throwable) {
                    try {
                        if (!bl) {
                            try {
                                this.rollback(virtualFileSystemOperation);
                            }
                            catch (InternalCriticalException internalCriticalException) {
                                if (!bl2) {
                                    throw new InternalCriticalException((Exception)((Object)internalCriticalException));
                                }
                                logger.error((Throwable)internalCriticalException, new String[]{this.objectInfo(string2, string), "---- not thrown ----"});
                            }
                            catch (Exception exception2) {
                                if (!bl2) {
                                    throw new InternalCriticalException(exception2, this.objectInfo(serverBucket, string));
                                }
                                logger.error((Throwable)exception2, new String[]{this.objectInfo(serverBucket, string), "---- not thrown ----"});
                            }
                        } else if (virtualFileSystemOperation != null && objectMetadata != null && objectMetadata2 != null) {
                            this.cleanUpRestoreVersion(objectMetadata, serverBucket, n, objectMetadata2);
                        }
                    }
                    finally {
                        this.getLockService().getBucketLock(serverBucket).readLock().unlock();
                    }
                    throw throwable;
                }
            }
        }
        finally {
            this.getLockService().getObjectLock(serverBucket, string).writeLock().unlock();
        }
    }

    private void cleanUpRestoreVersion(ObjectMetadata objectMetadata, ServerBucket serverBucket, int n, ObjectMetadata objectMetadata2) {
        try {
            if (n < 0) {
                return;
            }
            String string = objectMetadata.getObjectName();
            for (Drive drive : this.getDriver().getDrivesAll()) {
                FileUtils.deleteQuietly((File)drive.getObjectMetadataVersionFile(serverBucket, string, n));
                FileUtils.deleteQuietly((File)drive.getObjectMetadataVersionFile(serverBucket, string, objectMetadata2.getVersion()));
            }
            Object object = this.getDriver().getObjectDataFiles(objectMetadata, serverBucket, Optional.of(n));
            object.forEach(file -> FileUtils.deleteQuietly((File)file));
            object = this.getDriver().getObjectDataFiles(objectMetadata, serverBucket, Optional.of(objectMetadata2.getVersion()));
            object.forEach(file -> FileUtils.deleteQuietly((File)file));
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private void backupVersionObjectMetadata(ServerBucket serverBucket, String string, int n) {
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                File file = drive.getObjectMetadataFile(serverBucket, string);
                if (!file.exists()) continue;
                drive.putObjectMetadataVersionFile(serverBucket, string, n, file);
            }
        }
        catch (InternalCriticalException internalCriticalException) {
            throw internalCriticalException;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
        }
    }

    private void backupVersionObjectDataFile(ObjectMetadata objectMetadata, ServerBucket serverBucket, int n) {
        Map map = this.getDriver().getObjectDataFilesNames(objectMetadata, Optional.empty());
        for (Drive drive : map.keySet()) {
            for (String string : (List)map.get(drive)) {
                File file = new File(drive.getBucketObjectDataDirPath(serverBucket), string);
                String string2 = ".v" + String.valueOf(n);
                File file2 = new File(drive.getBucketObjectDataDirPath(serverBucket) + File.separator + "version", string + string2);
                try {
                    if (!file.exists()) continue;
                    Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    throw new InternalCriticalException((Exception)iOException, "src: " + file.getName() + " | back:" + file2.getName());
                }
            }
        }
    }

    private void saveObjectMetadata(ServerBucket serverBucket, String string2, RAIDSixBlocks rAIDSixBlocks, String string3, String string4, int n, OffsetDateTime offsetDateTime, Optional<List<String>> optional) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        ArrayList arrayList = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = serverBucket.getName();
        rAIDSixBlocks.getEncodedBlocks().forEach(file -> {
            try {
                arrayList.add(OdilonFileUtils.calculateSHA256String((File)file));
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(string5, string2, file.getName()));
            }
        });
        arrayList.forEach(string -> stringBuilder.append((String)string));
        String string6 = null;
        try {
            string6 = OdilonFileUtils.calculateSHA256String((String)stringBuilder.toString());
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            throw new InternalCriticalException(exception, this.objectInfo(string5, string2, string3));
        }
        OffsetDateTime offsetDateTime2 = OffsetDateTime.now();
        ArrayList<ObjectMetadata> arrayList2 = new ArrayList<ObjectMetadata>();
        for (Drive drive : this.getDriver().getDrivesAll()) {
            try {
                ObjectMetadata objectMetadata = new ObjectMetadata(serverBucket.getId(), string2);
                objectMetadata.setFileName(string3);
                objectMetadata.setAppVersion("1.15");
                objectMetadata.setContentType(string4);
                objectMetadata.setCreationDate(offsetDateTime);
                objectMetadata.setVersion(n);
                objectMetadata.setVersioncreationDate(offsetDateTime2);
                objectMetadata.setLength(rAIDSixBlocks.getFileSize());
                objectMetadata.setSourceLength(rAIDSixBlocks.getSrcFileSize());
                objectMetadata.setTotalBlocks(rAIDSixBlocks.getEncodedBlocks().size());
                objectMetadata.setSha256Blocks(arrayList);
                objectMetadata.setEtag(string6);
                objectMetadata.setEncrypt(this.getVirtualFileSystemService().isEncrypt());
                objectMetadata.setIntegrityCheck(objectMetadata.getCreationDate());
                objectMetadata.setStatus(ObjectStatus.ENABLED);
                objectMetadata.setDrive(drive.getName());
                objectMetadata.setRaid(String.valueOf(this.getRedundancyLevel().getCode()).trim());
                objectMetadata.setRaidDrives(this.getDriver().getTotalDisks());
                if (optional.isPresent()) {
                    objectMetadata.setCustomTags(optional.get());
                }
                arrayList2.add(objectMetadata);
            }
            catch (Exception exception) {
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string2));
            }
        }
        this.saveRAIDSixObjectMetadataToDisk(this.getDriver().getDrivesAll(), arrayList2, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RAIDSixBlocks saveObjectDataFile(ServerBucket serverBucket, String string, InputStream inputStream) {
        IOException iOException;
        RAIDSixBlocks rAIDSixBlocks;
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        InputStream inputStream2 = null;
        boolean bl = false;
        if (this.isEncrypt()) {
            IOException iOException2;
            RAIDSixBlocks rAIDSixBlocks2;
            try {
                EncryptedResult encryptedResult = this.getEncryptionService().encryptStream(inputStream);
                inputStream2 = encryptedResult.getInputStream();
                RAIDSixEncoder rAIDSixEncoder = new RAIDSixEncoder(this.getDriver());
                RAIDSixBlocks rAIDSixBlocks3 = rAIDSixEncoder.encodeHead(inputStream2, serverBucket, string);
                long l = encryptedResult.getCountingStream().getCount();
                rAIDSixBlocks3.setSrcFileSize(l);
                rAIDSixBlocks2 = rAIDSixBlocks3;
                iOException2 = null;
            }
            catch (Exception exception) {
                try {
                    bl = true;
                    throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
                }
                catch (Throwable throwable) {
                    IOException iOException3 = null;
                    try {
                        if (inputStream2 != null) {
                            inputStream2.close();
                        }
                    }
                    catch (IOException iOException4) {
                        logger.error((Throwable)iOException4, new String[]{this.objectInfo(serverBucket, string) + (bl ? "---- not thrown ----" : "")});
                        iOException3 = iOException4;
                    }
                    if (!bl && iOException3 != null) {
                        throw new InternalCriticalException(iOException3);
                    }
                    throw throwable;
                }
            }
            try {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
            catch (IOException iOException22) {
                logger.error((Throwable)iOException22, new String[]{this.objectInfo(serverBucket, string) + (bl ? "---- not thrown ----" : "")});
                iOException2 = iOException22;
            }
            if (!bl && iOException2 != null) {
                throw new InternalCriticalException(iOException2);
            }
            return rAIDSixBlocks2;
        }
        try {
            inputStream2 = inputStream;
            RAIDSixEncoder rAIDSixEncoder = new RAIDSixEncoder(this.getDriver());
            rAIDSixBlocks = rAIDSixEncoder.encodeHead(inputStream2, serverBucket, string);
            iOException = null;
        }
        catch (Exception exception) {
            try {
                bl = true;
                throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
            }
            catch (Throwable throwable) {
                IOException iOException6 = null;
                try {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (IOException iOException7) {
                    logger.error((Throwable)iOException7, new String[]{this.objectInfo(serverBucket, string) + (bl ? "---- not thrown ----" : "")});
                    iOException6 = iOException7;
                }
                if (!bl && iOException6 != null) {
                    throw new InternalCriticalException(iOException6);
                }
                throw throwable;
            }
        }
        try {
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        catch (IOException iOException5) {
            logger.error((Throwable)iOException5, new String[]{this.objectInfo(serverBucket, string) + (bl ? "---- not thrown ----" : "")});
            iOException = iOException5;
        }
        if (!bl && iOException != null) {
            throw new InternalCriticalException(iOException);
        }
        return rAIDSixBlocks;
    }

    private void backup(ObjectMetadata objectMetadata, ServerBucket serverBucket) {
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                File file = new File(drive.getObjectMetadataDirPath(serverBucket, objectMetadata.getObjectName()));
                if (!file.exists()) continue;
                File file2 = new File(drive.getBucketWorkDirPath(serverBucket) + File.separator + objectMetadata.getObjectName());
                FileUtils.copyDirectory((File)file, (File)file2);
            }
        }
        catch (IOException iOException) {
            throw new InternalCriticalException((Exception)iOException, this.objectInfo(objectMetadata));
        }
    }

    private void cleanUpBackupMetadataDir(ServerBucket serverBucket, String string) {
        try {
            for (Drive drive : this.getDriver().getDrivesAll()) {
                FileUtils.deleteQuietly((File)new File(drive.getBucketWorkDirPath(serverBucket) + File.separator + string));
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private void cleanUpUpdate(ObjectMetadata objectMetadata, ServerBucket serverBucket, int n, int n2) {
        if (objectMetadata == null) {
            return;
        }
        try {
            if (!this.getServerSettings().isVersionControl()) {
                for (Drive drive : this.getDriver().getDrivesAll()) {
                    FileUtils.deleteQuietly((File)drive.getObjectMetadataVersionFile(serverBucket, objectMetadata.getObjectName(), n));
                    List list = this.getDriver().getObjectDataFiles(objectMetadata, serverBucket, Optional.of(n));
                    list.forEach(file -> FileUtils.deleteQuietly((File)file));
                }
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, new String[]{"---- not thrown ----"});
        }
    }

    private void saveObjectMetadata(ObjectMetadata objectMetadata, boolean bl) {
        Check.requireNonNullArgument((Object)objectMetadata, (String)"meta is null");
        List list = this.getDriver().getDrivesAll();
        ArrayList arrayList = new ArrayList();
        this.getDriver().getDrivesAll().forEach(drive -> arrayList.add(objectMetadata));
        this.saveRAIDSixObjectMetadataToDisk(list, arrayList, bl);
    }

    private boolean restoreVersionObjectMetadata(ServerBucket serverBucket, String string, int n) {
        Check.requireNonNullArgument((Object)serverBucket, (String)"bucket is null");
        Check.requireNonNullArgument((Object)string, (String)("objectName is null or empty | b:" + serverBucket.getName()));
        try {
            boolean bl = true;
            ObjectMetadata objectMetadata = this.getDriver().getObjectMetadataVersion(serverBucket, string, n);
            for (Drive drive : this.getDriver().getDrivesAll()) {
                objectMetadata.setDrive(drive.getName());
                drive.saveObjectMetadata(objectMetadata);
            }
            return bl;
        }
        catch (InternalCriticalException internalCriticalException) {
            throw internalCriticalException;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(serverBucket, string));
        }
    }

    private boolean restoreVersionObjectDataFile(ObjectMetadata objectMetadata, ServerBucket serverBucket, int n) {
        Check.requireNonNullArgument((Object)objectMetadata.getBucketName(), (String)"bucketName is null");
        Check.requireNonNullArgument((Object)objectMetadata.getObjectName(), (String)("objectName is null or empty | b:" + objectMetadata.getBucketName()));
        try {
            Map map = this.getDriver().getObjectDataFilesNames(objectMetadata, Optional.of(n));
            for (Drive drive : map.keySet()) {
                for (String string : (List)map.get(drive)) {
                    String[] stringArray = string.split(".v");
                    String string2 = stringArray[0];
                    try {
                        if (!new File(drive.getBucketObjectDataDirPath(serverBucket) + File.separator + "version", string).exists()) continue;
                        Files.copy(new File(drive.getBucketObjectDataDirPath(serverBucket) + File.separator + "version", string).toPath(), new File(drive.getBucketObjectDataDirPath(serverBucket), string2).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException iOException) {
                        throw new InternalCriticalException((Exception)iOException, this.objectInfo(objectMetadata));
                    }
                }
            }
            return true;
        }
        catch (InternalCriticalException internalCriticalException) {
            throw internalCriticalException;
        }
        catch (Exception exception) {
            throw new InternalCriticalException(exception, this.objectInfo(objectMetadata));
        }
    }
}

