/*
 * Decompiled with CFR 0.152.
 */
package io.odilon.virtualFileSystem.raid6;

import io.odilon.virtualFileSystem.raid6.Galois;
import io.odilon.virtualFileSystem.raid6.Matrix;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReedSolomon {
    private final int dataShardCount;
    private final int parityShardCount;
    private final int totalShardCount;
    private final Matrix matrix;
    private final byte[][] parityRows;

    public ReedSolomon(int n, int n2) {
        this.dataShardCount = n;
        this.parityShardCount = n2;
        this.totalShardCount = n + n2;
        this.matrix = ReedSolomon.buildMatrix((int)n, (int)this.totalShardCount);
        this.parityRows = new byte[n2][];
        for (int i = 0; i < n2; ++i) {
            this.parityRows[i] = this.matrix.getRow(n + i);
        }
    }

    public int getDataShardCount() {
        return this.dataShardCount;
    }

    public int getParityShardCount() {
        return this.parityShardCount;
    }

    public int getTotalShardCount() {
        return this.totalShardCount;
    }

    public void encodeParity(byte[][] byArray, int n, int n2) {
        this.checkBuffersAndSizes(byArray, n, n2);
        byte[][] byArrayArray = new byte[this.parityShardCount][];
        for (int i = 0; i < this.parityShardCount; ++i) {
            byArrayArray[i] = byArray[this.dataShardCount + i];
        }
        this.codeSomeShards(this.parityRows, byArray, (byte[][])byArrayArray, this.parityShardCount, n, n2);
    }

    public boolean isParityCorrect(byte[][] byArray, int n, int n2) {
        this.checkBuffersAndSizes(byArray, n, n2);
        byte[][] byArrayArray = new byte[this.parityShardCount][];
        for (int i = 0; i < this.parityShardCount; ++i) {
            byArrayArray[i] = byArray[this.dataShardCount + i];
        }
        return this.checkSomeShards(this.parityRows, byArray, (byte[][])byArrayArray, this.parityShardCount, n, n2);
    }

    public void decodeMissing(byte[][] byArray, boolean[] blArray, int n, int n2) {
        int n3;
        this.checkBuffersAndSizes(byArray, n, n2);
        int n4 = 0;
        for (int i = 0; i < this.totalShardCount; ++i) {
            if (!blArray[i]) continue;
            ++n4;
        }
        if (n4 == this.totalShardCount) {
            return;
        }
        if (n4 < this.dataShardCount) {
            throw new IllegalArgumentException("Not enough shards present");
        }
        Matrix matrix = new Matrix(this.dataShardCount, this.dataShardCount);
        byte[][] byArrayArray = new byte[this.dataShardCount][];
        int n5 = 0;
        for (int i = 0; i < this.totalShardCount && n5 < this.dataShardCount; ++i) {
            if (!blArray[i]) continue;
            for (int j = 0; j < this.dataShardCount; ++j) {
                matrix.set(n5, j, this.matrix.get(i, j));
            }
            byArrayArray[n5] = byArray[i];
            ++n5;
        }
        Matrix matrix2 = matrix.invert();
        byte[][] byArrayArray2 = new byte[this.parityShardCount][];
        byte[][] byArrayArray3 = new byte[this.parityShardCount][];
        int n6 = 0;
        for (n3 = 0; n3 < this.dataShardCount; ++n3) {
            if (blArray[n3]) continue;
            byArrayArray2[n6] = byArray[n3];
            byArrayArray3[n6] = matrix2.getRow(n3);
            ++n6;
        }
        this.codeSomeShards((byte[][])byArrayArray3, (byte[][])byArrayArray, (byte[][])byArrayArray2, n6, n, n2);
        n6 = 0;
        for (n3 = this.dataShardCount; n3 < this.totalShardCount; ++n3) {
            if (blArray[n3]) continue;
            byArrayArray2[n6] = byArray[n3];
            byArrayArray3[n6] = this.parityRows[n3 - this.dataShardCount];
            ++n6;
        }
        this.codeSomeShards((byte[][])byArrayArray3, byArray, (byte[][])byArrayArray2, n6, n, n2);
    }

    private void checkBuffersAndSizes(byte[][] byArray, int n, int n2) {
        if (byArray.length != this.totalShardCount) {
            throw new IllegalArgumentException("wrong number of shards: " + byArray.length);
        }
        int n3 = byArray[0].length;
        for (int i = 1; i < byArray.length; ++i) {
            if (byArray[i].length == n3) continue;
            throw new IllegalArgumentException("Shards are different sizes");
        }
        if (n < 0) {
            throw new IllegalArgumentException("offset is negative: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("byteCount is negative: " + n2);
        }
        if (n3 < n + n2) {
            throw new IllegalArgumentException("buffers to small: " + n2 + n);
        }
    }

    private void codeSomeShards(byte[][] byArray, byte[][] byArray2, byte[][] byArray3, int n, int n2, int n3) {
        for (int i = n2; i < n2 + n3; ++i) {
            for (int j = 0; j < n; ++j) {
                byte[] byArray4 = byArray[j];
                int n4 = 0;
                for (int k = 0; k < this.dataShardCount; ++k) {
                    n4 ^= Galois.multiply((byte)byArray4[k], (byte)byArray2[k][i]);
                }
                byArray3[j][i] = (byte)n4;
            }
        }
    }

    private boolean checkSomeShards(byte[][] byArray, byte[][] byArray2, byte[][] byArray3, int n, int n2, int n3) {
        for (int i = n2; i < n2 + n3; ++i) {
            for (int j = 0; j < n; ++j) {
                byte[] byArray4 = byArray[j];
                int n4 = 0;
                for (int k = 0; k < this.dataShardCount; ++k) {
                    n4 ^= Galois.multiply((byte)byArray4[k], (byte)byArray2[k][i]);
                }
                if (byArray3[j][i] == (byte)n4) continue;
                return false;
            }
        }
        return true;
    }

    private static Matrix buildMatrix(int n, int n2) {
        Matrix matrix = ReedSolomon.vandermonde((int)n2, (int)n);
        Matrix matrix2 = matrix.submatrix(0, 0, n, n);
        return matrix.times(matrix2.invert());
    }

    private static Matrix vandermonde(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix.set(i, j, Galois.exp((byte)((byte)i), (int)j));
            }
        }
        return matrix;
    }
}

